/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.resource;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.gmf.util.GMFUnsafe;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;

public class TableResource
extends XMIResourceImpl {
    public TableResource(URI uri) {
        super(uri);
    }

    public void save(Map<?, ?> options) throws IOException {
        TransactionalEditingDomain domain = ((ModelSet)this.getResourceSet()).getTransactionalEditingDomain();
        CompoundCommand compoundCommand = new CompoundCommand("Modify top tables");
        for (EObject top : this.getContents()) {
            if (!(top instanceof Table)) continue;
            compoundCommand.append((Command)this.getDisposeTableCommand(domain, (Table)top));
        }
        try {
            try {
                GMFUnsafe.write((TransactionalEditingDomain)domain, (Command)compoundCommand);
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
                super.save(options);
            }
            catch (RollbackException e) {
                Activator.log.error((Throwable)e);
                super.save(options);
            }
        }
        finally {
            super.save(options);
        }
    }

    protected boolean useUUIDs() {
        return true;
    }

    protected void disposeTableCommand(Table table) {
        table.setContext(null);
        table.setOwner(null);
        table.getCurrentRowAxisProvider().eSet((EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.emptyList());
    }

    protected CompoundCommand getDisposeTableCommand(TransactionalEditingDomain domain, Table table) {
        CompoundCommand disposeCommand = new CompoundCommand("Command used to clean the table before disposing it");
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Context(), null));
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table, (Object)NattablePackage.eINSTANCE.getTable_Owner(), null));
        disposeCommand.append(SetCommand.create((EditingDomain)domain, (Object)table.getCurrentRowAxisProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.emptyList()));
        return disposeCommand;
    }
}

