/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.validator;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.filterrow.ParseResult;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.papyrus.infra.nattable.filter.FilterRowUtils;
import org.eclipse.papyrus.infra.nattable.filter.validator.AbstractFilterDataValidator;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public class DoubleFilterDataValidator
extends AbstractFilterDataValidator {
    public DoubleFilterDataValidator(String valueSeparator, TextMatchingMode matchingMode) {
        super(valueSeparator, matchingMode);
    }

    @Override
    public boolean validate(int columnIndex, int rowIndex, Object newValue) {
        List<ParseResult> res;
        if (TypeUtils.isDoubleValue((String)newValue.toString())) {
            return true;
        }
        try {
            res = FilterRowUtils.parse((String)newValue, this.valueSeparator, this.matchingMode);
        }
        catch (Exception e) {
            return false;
        }
        for (ParseResult current : res) {
            boolean tmp;
            String valueToMatch = current.getValueToMatch();
            if (valueToMatch == null || valueToMatch.equals("") || (tmp = TypeUtils.isDoubleValue((String)valueToMatch))) continue;
            return false;
        }
        return true;
    }
}

