/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.modelsnippet;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.AdjunctResourceModelSnippet;
import org.eclipse.papyrus.infra.core.resource.EMFLogicalModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;

public class PropertiesAdjunctResourceModelSnippet
extends AdjunctResourceModelSnippet {
    private InternationalizationModelResource model;
    private Adapter adapter;

    protected void loadResource(EMFLogicalModel model, ResourceSet resourceSet, URI adjunctURI) {
        if (adjunctURI.fileExtension().equals("properties")) {
            model.loadModel(adjunctURI.trimFileExtension());
        } else {
            super.loadResource(model, resourceSet, adjunctURI);
        }
    }

    public void start(IModel startingModel) {
        if (startingModel instanceof InternationalizationModelResource) {
            this.model = (InternationalizationModelResource)startingModel;
            this.adapter = new ResourceAdapter(){

                protected void handleResourceLoaded(Resource resource) {
                    PropertiesAdjunctResourceModelSnippet.this.loadAdjunctResource(resource);
                }
            };
            this.model.getModelManager().eAdapters().add((Object)this.adapter);
        }
    }

    protected void loadAdjunctResource(Resource resource) {
        if (this.model != null && !this.model.isRelatedResource(resource)) {
            URI adjunctURI = resource.getURI().trimFileExtension().appendFileExtension(this.model.getModelFileExtension());
            ResourceSet resourceSet = resource.getResourceSet();
            if (!this.model.isLoadedResourcesForURI(adjunctURI)) {
                this.loadResource((EMFLogicalModel)this.model, resourceSet, adjunctURI);
            }
        }
    }

    public void dispose(IModel stoppingModel) {
        if (stoppingModel == this.model && this.adapter != null) {
            this.model.getModelManager().eAdapters().remove((Object)this.adapter);
            this.adapter = null;
            this.model = null;
        }
    }
}

