/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.common.command;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;

public class UseInternationalizationPreferenceCommand
extends AbstractCommand {
    protected URI resourceURI;
    protected boolean newBooleanValue;
    protected boolean oldBooleanValue;

    public UseInternationalizationPreferenceCommand(URI resourceURI, boolean newBooleanValue) {
        super("Modify use internationalization preference");
        this.resourceURI = resourceURI;
        this.newBooleanValue = newBooleanValue;
    }

    public void execute() {
        this.oldBooleanValue = InternationalizationPreferencesUtils.getInternationalizationPreference(this.resourceURI);
        InternationalizationPreferencesUtils.setInternationalizationPreference(this.resourceURI, this.newBooleanValue);
    }

    public void undo() {
        InternationalizationPreferencesUtils.setInternationalizationPreference(this.resourceURI, this.oldBooleanValue);
    }

    public void redo() {
        InternationalizationPreferencesUtils.setInternationalizationPreference(this.resourceURI, this.newBooleanValue);
    }

    protected boolean prepare() {
        return this.resourceURI != null;
    }
}

