/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.reconciler;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramReconciler;
import org.eclipse.papyrus.infra.gmfdiag.common.reconciler.DiagramVersioningUtils;

public class DiagramReconcilersReader
extends RegistryReader {
    private static volatile DiagramReconcilersReader ourInstance = null;
    private static final String EXT_PT = "diagramReconciler";
    private static final String TAG_DIAGRAM_RECONCILER = "diagramReconciler";
    private Map<String, Collection<DiagramReconciler>> myReconcilers;
    private Map<String, Collection<DiagramReconciler>> myReconcilersRO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final DiagramReconcilersReader getInstance() {
        if (ourInstance != null) return ourInstance;
        Class<DiagramReconcilersReader> clazz = DiagramReconcilersReader.class;
        synchronized (DiagramReconcilersReader.class) {
            if (ourInstance != null) return ourInstance;
            ourInstance = new DiagramReconcilersReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourInstance;
        }
    }

    DiagramReconcilersReader() {
        super(Platform.getExtensionRegistry(), "org.eclipse.papyrus.infra.gmfdiag.common", "diagramReconciler");
    }

    public synchronized Map<String, Collection<DiagramReconciler>> load() {
        if (this.myReconcilers == null) {
            this.myReconcilers = new HashMap<String, Collection<DiagramReconciler>>();
            this.myReconcilersRO = Collections.unmodifiableMap(this.myReconcilers);
            this.readRegistry();
        }
        return this.myReconcilersRO;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (!"diagramReconciler".equals(element.getName())) {
            return false;
        }
        String className = element.getAttribute("reconcilerClass");
        String diagramTypeString = element.getAttribute("diagramType");
        String sourceVersion = element.getAttribute("source");
        String targetVersion = element.getAttribute("target");
        if (!DiagramReconcilersReader.checkNotEmpty(className)) {
            this.logMissingAttribute(element, "reconcilerClass");
            return false;
        }
        if (!DiagramReconcilersReader.checkNotEmpty(diagramTypeString)) {
            this.logMissingAttribute(element, "diagramType");
            return false;
        }
        if (!DiagramReconcilersReader.checkNotEmpty(sourceVersion)) {
            this.logMissingAttribute(element, "source");
            return false;
        }
        if (!DiagramReconcilersReader.checkNotEmpty(targetVersion)) {
            this.logMissingAttribute(element, "target");
            return false;
        }
        if (!DiagramVersioningUtils.isCurrentPapyrusVersion(targetVersion)) {
            Activator.log.debug("Reconciler for outdated version is still registered but will never be executed: " + className);
            return false;
        }
        if (add) {
            this.addDiagramReconciler(element);
        } else {
            this.removeDiagramReconciler(element);
        }
        return true;
    }

    private static boolean checkNotEmpty(String attr) {
        return attr != null && attr.length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDiagramReconciler(IConfigurationElement element) {
        DiagramReconciler reconciler = this.createReconciler(element);
        if (reconciler != null) {
            Map<String, Collection<DiagramReconciler>> map = this.myReconcilers;
            synchronized (map) {
                String diagramType = reconciler.getDiagramVisualID();
                Collection<DiagramReconciler> listForType = this.myReconcilers.get(diagramType);
                if (listForType == null) {
                    listForType = new LinkedList<DiagramReconciler>();
                    this.myReconcilers.put(diagramType, listForType);
                }
                listForType.add(reconciler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDiagramReconciler(IConfigurationElement element) {
        String diagramTypeString = element.getAttribute("diagramType");
        String fqn = element.getAttribute("reconcilerClass");
        if (diagramTypeString == null || fqn == null) {
            return;
        }
        Map<String, Collection<DiagramReconciler>> map = this.myReconcilers;
        synchronized (map) {
            Collection<DiagramReconciler> reconcilers = this.myReconcilers.get(diagramTypeString);
            if (reconcilers != null) {
                Iterator<DiagramReconciler> it = reconcilers.iterator();
                while (it.hasNext()) {
                    DiagramReconciler next = it.next();
                    if (!fqn.equals(next.getClassFqn())) continue;
                    it.remove();
                    break;
                }
                if (reconcilers.size() == 0) {
                    this.myReconcilers.remove(diagramTypeString);
                }
            }
        }
    }

    private DiagramReconciler createReconciler(IConfigurationElement element) {
        try {
            Object diagramReconcilerObject = element.createExecutableExtension("reconcilerClass");
            if (diagramReconcilerObject instanceof DiagramReconciler) {
                return (DiagramReconciler)diagramReconcilerObject;
            }
            Activator.log.error("Diagram reconciler extension does not extend mandatory DiagramReconciler base class: " + element.getAttribute("reconcilerClass"), null);
        }
        catch (CoreException e) {
            Activator.getInstance().getLog().log(e.getStatus());
        }
        return null;
    }
}

