/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.figure.node;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IRoundedRectangleFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.RectangularShadowBorder;
import org.eclipse.swt.graphics.Color;

public class RoundedRectangleShadowBorder
extends RectangularShadowBorder {
    int borderwidth = 3;
    Dimension cornerDimension;

    public RoundedRectangleShadowBorder(Color color, Dimension cornerDimension) {
        super(3, color);
        this.cornerDimension = cornerDimension;
        this.setWidth(1);
    }

    @Override
    public Insets getInsets(IFigure figure) {
        Insets insetsNew = super.getInsets(figure);
        insetsNew.top = 0;
        insetsNew.left = 0;
        insetsNew.bottom = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.bottom + this.borderwidth);
        insetsNew.right = MapModeUtil.getMapMode((IFigure)figure).DPtoLP(insetsNew.right + this.borderwidth);
        return insetsNew;
    }

    @Override
    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        graphics.pushState();
        tempRect.setBounds(RoundedRectangleShadowBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        RoundedRectangleShadowBorder.tempRect.x += this.getWidth() / 2;
        RoundedRectangleShadowBorder.tempRect.y += this.getWidth() / 2;
        RoundedRectangleShadowBorder.tempRect.width -= this.getWidth();
        RoundedRectangleShadowBorder.tempRect.height -= this.getWidth();
        if (figure instanceof IRoundedRectangleFigure) {
            this.cornerDimension.width = ((IRoundedRectangleFigure)figure).getCornerDimensions().width;
            this.cornerDimension.height = ((IRoundedRectangleFigure)figure).getCornerDimensions().height;
        }
        graphics.setLineWidth(this.getWidth());
        if (this.getColor() != null) {
            graphics.setBackgroundColor(this.getColor());
        } else {
            graphics.setBackgroundColor(ColorConstants.black);
        }
        graphics.setLineStyle(this.getStyle());
        graphics.drawRoundRectangle(tempRect, this.cornerDimension.width, this.cornerDimension.height);
        graphics.setLineStyle(1);
        Rectangle newRect = new Rectangle(tempRect);
        newRect.width += this.borderwidth;
        newRect.height += this.borderwidth;
        newRect.x += this.borderwidth;
        newRect.y += this.borderwidth;
        graphics.setClip(newRect);
        if (this.cornerDimension.width != 0 || this.cornerDimension.height != 0) {
            if (this.cornerDimension.width > RoundedRectangleShadowBorder.tempRect.width) {
                this.cornerDimension.width = RoundedRectangleShadowBorder.tempRect.width;
            }
            if (this.cornerDimension.height > RoundedRectangleShadowBorder.tempRect.height) {
                this.cornerDimension.height = RoundedRectangleShadowBorder.tempRect.height;
            }
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y, this.cornerDimension.width - 1, this.cornerDimension.height, -5, 45);
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y, this.cornerDimension.width - 2, this.cornerDimension.height, -5, 45);
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y, this.cornerDimension.width - 3, this.cornerDimension.height, -5, 45);
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth + RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height, this.cornerDimension.width, this.cornerDimension.height - 1, 210, 65);
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth + RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height, this.cornerDimension.width, this.cornerDimension.height - 2, 210, 65);
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth + RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height, this.cornerDimension.width, this.cornerDimension.height - 3, 210, 65);
            int tmpWidth = this.getWidth();
            graphics.setLineWidthFloat((float)((double)this.borderwidth - 0.5));
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth + RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height + this.getWidth() / 2, this.cornerDimension.width - 2 + this.getWidth() / 2, this.cornerDimension.height - 2, 270, 95);
            graphics.setLineWidth(tmpWidth);
            graphics.drawArc(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth + RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height + this.getWidth() / 2, this.cornerDimension.width - 3 + this.getWidth() / 2, this.cornerDimension.height - 3, 270, 95);
            if (RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height > 0) {
                graphics.fillRectangle(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width + this.getWidth() / 2, RoundedRectangleShadowBorder.tempRect.y + this.cornerDimension.height / 2, this.borderwidth, RoundedRectangleShadowBorder.tempRect.height - this.cornerDimension.height + this.borderwidth);
            }
            if (RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width > 0) {
                graphics.fillRectangle(RoundedRectangleShadowBorder.tempRect.x + this.cornerDimension.width / 2, RoundedRectangleShadowBorder.tempRect.y + RoundedRectangleShadowBorder.tempRect.height + this.getWidth() / 2, RoundedRectangleShadowBorder.tempRect.width - this.cornerDimension.width + this.borderwidth, this.borderwidth);
            }
        } else {
            PointList plt = new PointList();
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth);
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width, RoundedRectangleShadowBorder.tempRect.y + RoundedRectangleShadowBorder.tempRect.height);
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y + RoundedRectangleShadowBorder.tempRect.height);
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y + RoundedRectangleShadowBorder.tempRect.height + this.borderwidth);
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y + RoundedRectangleShadowBorder.tempRect.height + this.borderwidth);
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width + this.borderwidth, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth);
            plt.addPoint(RoundedRectangleShadowBorder.tempRect.x + RoundedRectangleShadowBorder.tempRect.width, RoundedRectangleShadowBorder.tempRect.y + this.borderwidth);
            graphics.fillPolygon(plt);
        }
        graphics.popState();
    }
}

