/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.ETypedElementSelectionControl;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.ETypedElementSelectionSortedControl;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.IETypedElementSelectionControlManager;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.IETypedElementSelectionWidgetInternal;
import org.eclipse.papyrus.emf.facet.efacet.ui.internal.widget.IETypedElementTabSelectionWidgetInternal;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.dialogs.FilteredTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETypedElementSelectionControlManager
implements IETypedElementSelectionControlManager {
    private final Map<TabItem, IETypedElementTabSelectionWidgetInternal> trees = new HashMap<TabItem, IETypedElementTabSelectionWidgetInternal>();
    private TabFolder tabFolder;
    private final Composite parentComposite;
    private final int selectionMaxSize;
    private final boolean emptySelection;
    private final ICustomizationManager customManager;
    private Collection<? extends ETypedElement> availableElements;
    private final Collection<? extends EObject> knownEPackage;

    public ETypedElementSelectionControlManager(Composite parentComposite, int selectionMaxSize, boolean emptySelection, ICustomizationManager customManager, Collection<? extends EObject> knownEPackage) {
        this.parentComposite = parentComposite;
        this.selectionMaxSize = selectionMaxSize;
        this.emptySelection = emptySelection;
        this.customManager = customManager;
        this.knownEPackage = knownEPackage;
    }

    private static Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    private void init() {
        this.tabFolder = new TabFolder(this.parentComposite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem flatItem = new TabItem(this.tabFolder, 0);
        Composite flatComposite = ETypedElementSelectionControlManager.createComposite((Composite)this.tabFolder);
        ETypedElementSelectionControl filteredTree = new ETypedElementSelectionControl(flatComposite, this.selectionMaxSize, this.emptySelection, this.customManager, this.knownEPackage);
        flatItem.setText(filteredTree.getTitle());
        flatItem.setToolTipText(filteredTree.getToolTipText());
        flatItem.setImage(filteredTree.getImage());
        this.trees.put(flatItem, filteredTree);
        flatItem.setControl((Control)flatComposite);
        TabItem sortedItem = new TabItem(this.tabFolder, 0);
        Composite sortedComposite = ETypedElementSelectionControlManager.createComposite((Composite)this.tabFolder);
        filteredTree = new ETypedElementSelectionSortedControl(sortedComposite, this.selectionMaxSize, this.emptySelection, this.customManager, this.knownEPackage);
        sortedItem.setText(filteredTree.getTitle());
        sortedItem.setToolTipText(filteredTree.getToolTipText());
        sortedItem.setImage(filteredTree.getImage());
        sortedItem.setControl((Control)sortedComposite);
        this.trees.put(sortedItem, filteredTree);
        this.initSelectedTabItem();
    }

    private IETypedElementTabSelectionWidgetInternal getActiveTree() {
        int selectionIndex = this.tabFolder.getSelectionIndex();
        TabItem currentTabItem = this.tabFolder.getItem(selectionIndex);
        return this.trees.get(currentTabItem);
    }

    @Override
    public void addOpenListener(IOpenListener openListener) {
        for (IETypedElementSelectionWidgetInternal iETypedElementSelectionWidgetInternal : this.trees.values()) {
            iETypedElementSelectionWidgetInternal.addOpenListener(openListener);
        }
    }

    @Override
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        for (IETypedElementSelectionWidgetInternal iETypedElementSelectionWidgetInternal : this.trees.values()) {
            iETypedElementSelectionWidgetInternal.addSelectionChangedListener(listener);
        }
    }

    private void initSelectedTabItem() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String value = store.getString("ETypedElementSelectionDialogPreferedTab");
        TabItem[] tabItemArray = this.tabFolder.getItems();
        int n = tabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TabItem item = tabItemArray[n2];
            if (item.getText().equals(value)) {
                this.tabFolder.setSelection(item);
                return;
            }
            ++n2;
        }
    }

    @Override
    public IStatus getValidationStatus() {
        return this.getActiveTree().getValidationStatus();
    }

    @Override
    public void setAvailableETypedElements(Collection<? extends ETypedElement> availableTE) {
        this.availableElements = availableTE;
        for (IETypedElementSelectionWidgetInternal iETypedElementSelectionWidgetInternal : this.trees.values()) {
            iETypedElementSelectionWidgetInternal.setAvailableETypedElements(availableTE);
        }
    }

    @Override
    public List<ETypedElement> getSelectedETypedElements() {
        return this.getActiveTree().getSelectedETypedElements();
    }

    private void updatePreferenceValue() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String value = this.getActiveTree().getTitle();
        store.setValue("ETypedElementSelectionDialogPreferedTab", value);
    }

    @Override
    public void setSelectedETypedElements(Collection<? extends ETypedElement> newSelection) {
        if (newSelection == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ETypedElement> filteredSelection = new ArrayList<ETypedElement>();
        for (ETypedElement eTypedElement : newSelection) {
            if (!this.availableElements.contains(eTypedElement)) continue;
            filteredSelection.add(eTypedElement);
        }
        this.setSelection((IStructuredSelection)new StructuredSelection(filteredSelection));
    }

    @Override
    public void setSelection(IStructuredSelection selection) {
        for (IETypedElementSelectionWidgetInternal iETypedElementSelectionWidgetInternal : this.trees.values()) {
            iETypedElementSelectionWidgetInternal.setSelection(selection);
        }
    }

    @Override
    public List<ETypedElement> computeResult() {
        this.updatePreferenceValue();
        return this.getActiveTree().getSelectedETypedElements();
    }

    @Override
    public boolean isDisposed() {
        return this.tabFolder == null || this.tabFolder.isDisposed() || this.getActiveTree().isDisposed();
    }

    @Override
    public FilteredTree getFilteredTree() {
        return this.getActiveTree().getFilteredTree();
    }

    @Override
    public void createContents() {
        this.init();
        for (IETypedElementSelectionWidgetInternal iETypedElementSelectionWidgetInternal : this.trees.values()) {
            iETypedElementSelectionWidgetInternal.createContents();
        }
    }
}

