/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.project;

import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.file.BuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.file.ClasspathEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IBuildEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IClasspathEditor;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IJavaProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.AbstractProjectEditor;
import org.eclipse.papyrus.eclipse.project.editors.project.ProjectEditor;

public class JavaProjectEditor
extends ProjectEditor
implements IJavaProjectEditor {
    private final IJavaProject javaProject;
    private final IClasspathEditor classpathEditor;
    private final IBuildEditor buildEditor;

    public IClasspathEditor getClasspathEditor() {
        return this.classpathEditor;
    }

    public IBuildEditor getBuildEditor() {
        return this.buildEditor;
    }

    public JavaProjectEditor(IProject project) throws CoreException {
        super(project);
        this.javaProject = JavaCore.create((IProject)project);
        this.buildEditor = new BuildEditor(project);
        this.classpathEditor = new ClasspathEditor(this.javaProject);
    }

    JavaProjectEditor(AbstractProjectEditor master) {
        super(master);
        this.javaProject = JavaCore.create((IProject)master.getProject());
        this.buildEditor = new BuildEditor(master.getProject());
        this.classpathEditor = new ClasspathEditor(this.javaProject);
    }

    @Override
    public boolean exists() {
        return super.exists() && this.javaProject.exists();
    }

    @Override
    public Set<String> getMissingFiles() {
        Set<String> files = super.getMissingFiles();
        files.addAll(this.classpathEditor.getMissingFiles());
        files.addAll(this.buildEditor.getMissingFiles());
        return files;
    }

    @Override
    public Set<String> getMissingNature() {
        Set<String> natures = super.getMissingNature();
        if (!this.hasNature("org.eclipse.jdt.core.javanature")) {
            natures.add("org.eclipse.jdt.core.javanature");
        }
        return natures;
    }

    @Override
    public void init() {
        this.classpathEditor.init();
        this.buildEditor.init();
    }

    @Override
    public void createFiles(Set<String> files) {
        super.createFiles(files);
        this.classpathEditor.createFiles(files);
        this.buildEditor.createFiles(files);
    }

    @Override
    public boolean isDirty() {
        return super.isDirty() || this.classpathEditor.isDirty() || this.buildEditor.isDirty();
    }

    @Override
    protected void doSave() {
        super.doSave();
        try {
            this.javaProject.save((IProgressMonitor)new NullProgressMonitor(), true);
        }
        catch (JavaModelException ex) {
            Activator.log.error((Throwable)ex);
        }
        this.classpathEditor.save();
        this.buildEditor.save();
    }

    @Override
    public void addJavaSourceFolder(String path) {
        if (this.exists()) {
            String classPath = path;
            this.classpathEditor.addSourceFolderToClasspath(classPath);
            this.buildEditor.registerSourceFolder(String.valueOf(path) + "/");
        }
    }

    @Override
    public IPackageFragment addPackage(String sourceFolderName, String packageName) {
        IPackageFragment createdPackage = null;
        if (this.exists()) {
            this.touch();
            IFolder sourceFolder = null;
            if (sourceFolderName != null && !sourceFolderName.isEmpty() && this.classpathEditor.isSourceFolderRegistered(sourceFolderName)) {
                sourceFolder = this.javaProject.getProject().getFolder(sourceFolderName);
            } else {
                String[] sourceFolders = this.classpathEditor.getSourceFolders();
                if (sourceFolders.length > 0) {
                    sourceFolder = this.javaProject.getProject().getFolder(sourceFolders[0]);
                }
            }
            if (!(sourceFolder == null || (createdPackage = this.javaProject.getPackageFragmentRoot(sourceFolder).getPackageFragment(packageName)) != null && createdPackage.exists())) {
                try {
                    createdPackage = this.javaProject.getPackageFragmentRoot((IResource)sourceFolder).createPackageFragment(packageName, false, null);
                }
                catch (JavaModelException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
        return createdPackage;
    }

    @Override
    public ICompilationUnit addClass(String sourceFolderName, String packageName, String className, String content) {
        ICompilationUnit createdClass = null;
        if (this.exists()) {
            this.touch();
            IPackageFragment packageFragment = this.addPackage(sourceFolderName, packageName);
            try {
                createdClass = packageFragment.createCompilationUnit(String.valueOf(className) + ".java", content, false, null);
            }
            catch (JavaModelException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return createdClass;
    }

    @Override
    public void registerSourceFolder(String string) {
        this.buildEditor.registerSourceFolder(string);
    }

    @Override
    public void addToBuild(String path) {
        this.buildEditor.addToBuild(path);
    }

    @Override
    public boolean isRegisteredSourceFolder(String path) {
        return this.buildEditor.isRegisteredSourceFolder(path);
    }

    @Override
    public String[] getSourceFolders() {
        return this.buildEditor.getSourceFolders();
    }

    @Override
    public Set<String> getMissingBuildCommand() {
        Set<String> buildCommand = super.getMissingBuildCommand();
        if (!this.hasBuildCommand("org.eclipse.jdt.core.javabuilder")) {
            buildCommand.add("org.eclipse.jdt.core.javabuilder");
        }
        return buildCommand;
    }

    @Override
    public void removeFromBuild(String path) {
        this.buildEditor.removeFromBuild(path);
    }

    @Override
    public String[] getElementsInBuild() {
        return this.buildEditor.getElementsInBuild();
    }

    @Override
    public void registerBinFolder(String binFolder) {
        this.buildEditor.registerBinFolder(binFolder);
    }

    @Override
    public boolean isRegisteredBinFolder(String binFolder) {
        return this.buildEditor.isRegisteredBinFolder(binFolder);
    }

    @Override
    public void addSourceFolderToClasspath(String folderPath) {
        this.classpathEditor.addSourceFolderToClasspath(folderPath);
    }

    @Override
    public void addSourceFolderToClasspath(String srcPath, String binPath) {
        this.classpathEditor.addSourceFolderToClasspath(srcPath, binPath);
    }

    @Override
    public boolean isSourceFolderRegistered(String folderPath) {
        return this.classpathEditor.isSourceFolderRegistered(folderPath);
    }

    @Override
    public String[] getBinFolders() {
        return this.classpathEditor.getBinFolders();
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }
}

