/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.gridfs;

import com.mongodb.MongoClient;
import com.mongodb.MongoGridFSException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSDownloadStreamImpl;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.GridFSFindIterableImpl;
import com.mongodb.client.gridfs.GridFSUploadStream;
import com.mongodb.client.gridfs.GridFSUploadStreamImpl;
import com.mongodb.client.gridfs.model.GridFSDownloadByNameOptions;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.bson.BsonDocument;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

final class GridFSBucketImpl
implements GridFSBucket {
    private static final int DEFAULT_CHUNKSIZE_BYTES = 261120;
    private final String bucketName;
    private final int chunkSizeBytes;
    private final MongoCollection<Document> filesCollection;
    private final MongoCollection<Document> chunksCollection;
    private volatile boolean checkedIndexes;

    GridFSBucketImpl(MongoDatabase database) {
        this(database, "fs");
    }

    GridFSBucketImpl(MongoDatabase database, String bucketName) {
        this(Assertions.notNull("bucketName", bucketName), 261120, GridFSBucketImpl.getFilesCollection(Assertions.notNull("database", database), bucketName), GridFSBucketImpl.getChunksCollection(database, bucketName));
    }

    GridFSBucketImpl(String bucketName, int chunkSizeBytes, MongoCollection<Document> filesCollection, MongoCollection<Document> chunksCollection) {
        this.bucketName = Assertions.notNull("bucketName", bucketName);
        this.chunkSizeBytes = chunkSizeBytes;
        this.filesCollection = Assertions.notNull("filesCollection", filesCollection);
        this.chunksCollection = Assertions.notNull("chunksCollection", chunksCollection);
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public int getChunkSizeBytes() {
        return this.chunkSizeBytes;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.filesCollection.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.filesCollection.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.filesCollection.getReadConcern();
    }

    @Override
    public GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.bucketName, chunkSizeBytes, this.filesCollection, this.chunksCollection);
    }

    @Override
    public GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadPreference(readPreference), this.chunksCollection.withReadPreference(readPreference));
    }

    @Override
    public GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withWriteConcern(writeConcern), this.chunksCollection.withWriteConcern(writeConcern));
    }

    @Override
    public GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.bucketName, this.chunkSizeBytes, this.filesCollection.withReadConcern(readConcern), this.chunksCollection.withReadConcern(readConcern));
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream(filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        int chunkSize = options.getChunkSizeBytes() == null ? this.chunkSizeBytes : options.getChunkSizeBytes();
        this.checkCreateIndex();
        return new GridFSUploadStreamImpl(this.filesCollection, this.chunksCollection, new ObjectId(), filename, chunkSize, options.getMetadata());
    }

    @Override
    public ObjectId uploadFromStream(String filename, InputStream source) {
        return this.uploadFromStream(filename, source, new GridFSUploadOptions());
    }

    @Override
    public ObjectId uploadFromStream(String filename, InputStream source, GridFSUploadOptions options) {
        GridFSUploadStream uploadStream = this.openUploadStream(filename, options);
        int chunkSize = options.getChunkSizeBytes() == null ? this.chunkSizeBytes : options.getChunkSizeBytes();
        byte[] buffer = new byte[chunkSize];
        try {
            int len;
            while ((len = source.read(buffer)) != -1) {
                uploadStream.write(buffer, 0, len);
            }
            uploadStream.close();
        }
        catch (IOException e) {
            uploadStream.abort();
            throw new MongoGridFSException("IOException when reading from the InputStream", e);
        }
        return uploadStream.getFileId();
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId id) {
        return this.findTheFileInfoAndOpenDownloadStream(new BsonObjectId(id));
    }

    @Override
    public void downloadToStream(ObjectId id, OutputStream destination) {
        this.downloadToStream(this.findTheFileInfoAndOpenDownloadStream(new BsonObjectId(id)), destination);
    }

    @Override
    public void downloadToStream(BsonValue id, OutputStream destination) {
        this.downloadToStream(this.findTheFileInfoAndOpenDownloadStream(id), destination);
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue id) {
        return this.findTheFileInfoAndOpenDownloadStream(id);
    }

    @Override
    public GridFSDownloadStream openDownloadStreamByName(String filename) {
        return this.openDownloadStreamByName(filename, new GridFSDownloadByNameOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStreamByName(String filename, GridFSDownloadByNameOptions options) {
        return new GridFSDownloadStreamImpl(this.getFileByName(filename, options), this.chunksCollection);
    }

    @Override
    public void downloadToStreamByName(String filename, OutputStream destination) {
        this.downloadToStreamByName(filename, destination, new GridFSDownloadByNameOptions());
    }

    @Override
    public void downloadToStreamByName(String filename, OutputStream destination, GridFSDownloadByNameOptions options) {
        this.downloadToStream(this.openDownloadStreamByName(filename, options), destination);
    }

    @Override
    public GridFSFindIterable find() {
        return new GridFSFindIterableImpl(this.filesCollection.find());
    }

    @Override
    public GridFSFindIterable find(Bson filter) {
        return this.find().filter(filter);
    }

    @Override
    public void delete(ObjectId id) {
        DeleteResult result = this.filesCollection.deleteOne(new BsonDocument("_id", new BsonObjectId(id)));
        this.chunksCollection.deleteMany(new BsonDocument("files_id", new BsonObjectId(id)));
        if (result.wasAcknowledged() && result.getDeletedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id));
        }
    }

    @Override
    public void rename(ObjectId id, String newFilename) {
        UpdateResult updateResult = this.filesCollection.updateOne(new Document("_id", id), new Document("$set", new Document("filename", newFilename)));
        if (updateResult.wasAcknowledged() && updateResult.getMatchedCount() == 0L) {
            throw new MongoGridFSException(String.format("No file found with the ObjectId: %s", id));
        }
    }

    @Override
    public void drop() {
        this.filesCollection.drop();
        this.chunksCollection.drop();
    }

    private static MongoCollection<Document> getFilesCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".files").withCodecRegistry(CodecRegistries.fromRegistries(database.getCodecRegistry(), MongoClient.getDefaultCodecRegistry()));
    }

    private static MongoCollection<Document> getChunksCollection(MongoDatabase database, String bucketName) {
        return database.getCollection(bucketName + ".chunks").withCodecRegistry(MongoClient.getDefaultCodecRegistry());
    }

    private void checkCreateIndex() {
        if (!this.checkedIndexes) {
            if (this.filesCollection.withReadPreference(ReadPreference.primary()).find().projection(new Document("_id", 1)).first() == null) {
                Document filesIndex = new Document("filename", 1).append("uploadDate", 1);
                if (!this.hasIndex(this.filesCollection.withReadPreference(ReadPreference.primary()), filesIndex)) {
                    this.filesCollection.createIndex(filesIndex);
                }
                Document chunksIndex = new Document("files_id", 1).append("n", 1);
                if (!this.hasIndex(this.chunksCollection.withReadPreference(ReadPreference.primary()), chunksIndex)) {
                    this.chunksCollection.createIndex(chunksIndex, new IndexOptions().unique(true));
                }
            }
            this.checkedIndexes = true;
        }
    }

    private boolean hasIndex(MongoCollection<Document> collection, Document index) {
        boolean hasIndex = false;
        ArrayList indexes = collection.listIndexes().into(new ArrayList());
        for (Document indexDoc : indexes) {
            if (!indexDoc.get("key", Document.class).equals(index)) continue;
            hasIndex = true;
            break;
        }
        return hasIndex;
    }

    private GridFSFile getFileByName(String filename, GridFSDownloadByNameOptions options) {
        int sort;
        int skip;
        int revision = options.getRevision();
        if (revision >= 0) {
            skip = revision;
            sort = 1;
        } else {
            skip = -revision - 1;
            sort = -1;
        }
        GridFSFile fileInfo = (GridFSFile)this.find(new Document("filename", filename)).skip(skip).sort(new Document("uploadDate", sort)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the filename: %s and revision: %s", filename, revision));
        }
        return fileInfo;
    }

    private GridFSDownloadStream findTheFileInfoAndOpenDownloadStream(BsonValue id) {
        GridFSFile fileInfo = (GridFSFile)this.find(new Document("_id", id)).first();
        if (fileInfo == null) {
            throw new MongoGridFSException(String.format("No file found with the id: %s", id));
        }
        return new GridFSDownloadStreamImpl(fileInfo, this.chunksCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadToStream(GridFSDownloadStream downloadStream, OutputStream destination) {
        block16: {
            byte[] buffer = new byte[downloadStream.getGridFSFile().getChunkSize()];
            MongoGridFSException savedThrowable = null;
            try {
                int len;
                while ((len = downloadStream.read(buffer)) != -1) {
                    destination.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                savedThrowable = new MongoGridFSException("IOException when reading from the OutputStream", e);
            }
            catch (Exception e) {
                savedThrowable = new MongoGridFSException("Unexpected Exception when reading GridFS and writing to the Stream", e);
            }
            finally {
                try {
                    downloadStream.close();
                }
                catch (Exception e) {}
                if (savedThrowable == null) break block16;
                throw savedThrowable;
            }
        }
    }
}

