/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.oomph.internal.version.Activator;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;
import org.eclipse.oomph.version.ui.quickfixes.Messages;
import org.eclipse.osgi.util.NLS;

public class IgnoreRootProjectsResolution
extends AbstractResolution {
    public IgnoreRootProjectsResolution(IMarker marker) {
        super(marker, Messages.IgnoreRootProjectsResolution_label, "icons/correction_configure.gif");
    }

    protected boolean isApplicable(IMarker marker) {
        return "unreferenced.element".equals(Markers.getProblemType((IMarker)marker));
    }

    public String getDescription() {
        IMarker marker = this.getMarker();
        IProject project = marker.getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        return NLS.bind((String)Messages.IgnoreRootProjectsResolution_description, (Object)arguments.getReleasePath());
    }

    protected void apply(IMarker marker) throws Exception {
        IProject project = marker.getResource().getProject();
        VersionBuilderArguments arguments = new VersionBuilderArguments(project);
        String releasePath = arguments.getReleasePath();
        Activator.setReleaseCheckMode((String)releasePath, (Activator.ReleaseCheckMode)Activator.ReleaseCheckMode.PARTIAL);
        VersionUtil.cleanReleaseProjects((String)releasePath);
    }
}

