/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.library.AbstractEvaluatorIterableIterationManager;
import org.eclipse.ocl.pivot.values.MapValue;

public class EvaluatorMultipleMapIterationManager
extends AbstractEvaluatorIterableIterationManager<MapValue> {
    protected final AbstractEvaluatorIterableIterationManager.MapValueIterator[] iterators;
    protected boolean hasCurrent;

    public EvaluatorMultipleMapIterationManager(@NonNull Executor invokingExecutor, CallExp callExp, @NonNull OCLExpression body, @NonNull MapValue mapValue, @Nullable TypedElement accumulator, @Nullable Object accumulatorValue, @NonNull TypedElement[] referredKeyIterators, @Nullable TypedElement[] referredValueIterators) {
        super(invokingExecutor, callExp, body, mapValue, accumulator, accumulatorValue);
        int iMax = referredKeyIterators.length;
        AbstractEvaluatorIterableIterationManager.MapValueIterator[] iterators = new AbstractEvaluatorIterableIterationManager.MapValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            TypedElement referredKeyIterator = referredKeyIterators[i];
            AbstractEvaluatorIterableIterationManager.MapValueIterator valueIterator = new AbstractEvaluatorIterableIterationManager.MapValueIterator(this.executor, mapValue, referredKeyIterator, referredValueIterators[i]);
            if (!valueIterator.hasCurrent()) {
                this.iterators = null;
                this.hasCurrent = false;
                return;
            }
            iterators[i] = valueIterator;
            ++i;
        }
        this.iterators = iterators;
        this.hasCurrent = true;
    }

    @Override
    public boolean advanceIterators() {
        if (this.hasCurrent) {
            AbstractEvaluatorIterableIterationManager.MapValueIterator[] mapValueIteratorArray = this.iterators;
            int n = this.iterators.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractEvaluatorIterableIterationManager.MapValueIterator advancingIterator = mapValueIteratorArray[n2];
                advancingIterator.next();
                if (advancingIterator.hasCurrent()) {
                    AbstractEvaluatorIterableIterationManager.MapValueIterator[] mapValueIteratorArray2 = this.iterators;
                    int n3 = this.iterators.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AbstractEvaluatorIterableIterationManager.MapValueIterator previousIterator = mapValueIteratorArray2[n4];
                        if (previousIterator == advancingIterator) {
                            return true;
                        }
                        previousIterator.reset();
                        ++n4;
                    }
                }
                ++n2;
            }
            this.hasCurrent = false;
        }
        return false;
    }

    public @NonNull Object get(int i) {
        Object currentValue = this.iterators[i].get();
        if (currentValue == null) {
            throw new IllegalStateException("cannot get() after iteration complete");
        }
        return currentValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.hasCurrent;
    }
}

