/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.BasicEAnnotationValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.annotations.PivotAnnotationsPackage;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.util.PivotPlugin;
import org.eclipse.osgi.util.NLS;

public abstract class BasicEAnnotationValidator2
extends BasicEAnnotationValidator {
    private final List<EClass> annotatableClasses = new ArrayList<EClass>();
    private Map<EClass, EClass> annotatedClass2annotationClass = new HashMap<EClass, EClass>();
    private final Map<EClass, Map<String, EStructuralFeature>> annotationClass2name2annotationProperty = new HashMap<EClass, Map<String, EStructuralFeature>>();

    protected BasicEAnnotationValidator2(String annotationSource, String annotationName, String diagnosticSource, EClass ... eAnnotationMetaClasses) {
        super(annotationSource, annotationName, diagnosticSource);
        if (eAnnotationMetaClasses != null) {
            EClass[] eClassArray = eAnnotationMetaClasses;
            int n = eAnnotationMetaClasses.length;
            int n2 = 0;
            while (n2 < n) {
                EClass eAnnotationMetaClass = eClassArray[n2];
                EAnnotation eAnnotation = eAnnotationMetaClass.getEAnnotation("http://www.eclipse.org/OCL/MetaAnnotation");
                if (eAnnotation != null) {
                    for (EObject reference : eAnnotation.getReferences()) {
                        if (!(reference instanceof EClass)) continue;
                        EClass annotatableClass = (EClass)reference;
                        this.annotatableClasses.add(annotatableClass);
                        this.annotatedClass2annotationClass.put(annotatableClass, eAnnotationMetaClass);
                    }
                }
                ++n2;
            }
        }
    }

    protected EClass getAnnotationClass(EClass annotatedClass) {
        EClass annotationClass = this.annotatedClass2annotationClass.get(annotatedClass);
        if (annotationClass == null && !this.annotatedClass2annotationClass.containsKey(annotatedClass)) {
            for (EClass eSuperClass : annotatedClass.getESuperTypes()) {
                annotationClass = this.getAnnotationClass(eSuperClass);
                if (annotationClass != null) break;
            }
            this.annotatedClass2annotationClass.put(annotatedClass, annotationClass);
        }
        return annotationClass;
    }

    protected List<EClass> getPropertyClasses(EModelElement eModelElement) {
        EClass annotationClass = this.getAnnotationClass(eModelElement.eClass());
        return annotationClass != null ? Collections.singletonList(annotationClass) : Collections.emptyList();
    }

    protected Map<String, EStructuralFeature> getNoFeatureProperties(EModelElement eModelElement) {
        HashMap<String, EStructuralFeature> properties = new HashMap<String, EStructuralFeature>();
        EAnnotation eAnnotation = eModelElement.getEAnnotation(this.annotationSource);
        if (eAnnotation != null) {
            for (String key : eAnnotation.getDetails().keySet()) {
                properties.put(key, null);
            }
        }
        return properties;
    }

    protected Map<String, EStructuralFeature> getProperties(EModelElement eModelElement) {
        EClass annotationClass = this.getAnnotationClass(eModelElement.eClass());
        if (annotationClass != null) {
            Map<String, EStructuralFeature> name2annotationProperty = this.annotationClass2name2annotationProperty.get(annotationClass);
            if (name2annotationProperty == null) {
                name2annotationProperty = new HashMap<String, EStructuralFeature>();
                this.annotationClass2name2annotationProperty.put(annotationClass, name2annotationProperty);
                for (EStructuralFeature eStructuralFeature : annotationClass.getEAllStructuralFeatures()) {
                    name2annotationProperty.put(eStructuralFeature.getName(), eStructuralFeature);
                }
            }
            return name2annotationProperty;
        }
        return null;
    }

    protected ResourceLocator getResourceLocator() {
        return PivotPlugin.INSTANCE;
    }

    protected String getValidLocationDescription() {
        StringBuilder s = new StringBuilder();
        for (EClassifier eClassifier : this.annotatableClasses) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(eClassifier.getName());
        }
        String string = "a {0}";
        String _UI_ValidAnnotationLocationDescriptions = "one of {0}";
        return NLS.bind((String)(this.annotatableClasses.size() > 1 ? _UI_ValidAnnotationLocationDescriptions : string), (Object)s.toString());
    }

    protected boolean isValidLocation(EAnnotation eAnnotation, EModelElement eModelElement) {
        return this.getAnnotationClass(eModelElement.eClass()) != null;
    }

    protected boolean validateFeatureDetail(EAnnotation eAnnotation, EModelElement eModelElement, Map.Entry<String, String> entry, EStructuralFeature feature, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int oldChildren;
        BasicDiagnostic childDiagnostic;
        if (diagnostics instanceof PivotDiagnostician.BasicDiagnosticWithRemove) {
            childDiagnostic = (BasicDiagnostic)diagnostics;
            oldChildren = childDiagnostic.getChildren().size();
        } else if (diagnostics == null) {
            childDiagnostic = null;
            oldChildren = -1;
        } else {
            childDiagnostic = this.createValueDiagnostic(eAnnotation, eModelElement, entry, feature);
            oldChildren = -1;
        }
        ArrayList values = new ArrayList();
        boolean bl = result = feature instanceof EAttribute ? this.validateAttributeDetailLiteralValue(eAnnotation, eModelElement, entry, (EAttribute)feature, values, (DiagnosticChain)childDiagnostic, context) : this.validateReferenceDetailLiteralValue(eAnnotation, eModelElement, entry, (EReference)feature, values, (DiagnosticChain)childDiagnostic, context);
        if (result) {
            result &= this.validateFeatureDetailValue(eAnnotation, eModelElement, entry, feature, values, (DiagnosticChain)childDiagnostic, context);
        }
        if (!result && diagnostics != null) {
            if (childDiagnostic instanceof PivotDiagnostician.BasicDiagnosticWithRemove && oldChildren >= 0) {
                BasicDiagnostic badValueDiagnostic = this.createValueDiagnostic(eAnnotation, eModelElement, entry, feature);
                List children = childDiagnostic.getChildren();
                int i = oldChildren;
                while (i < children.size()) {
                    badValueDiagnostic.add(((PivotDiagnostician.BasicDiagnosticWithRemove)childDiagnostic).remove(i));
                    ++i;
                }
                diagnostics.add((Diagnostic)badValueDiagnostic);
            } else {
                diagnostics.add((Diagnostic)childDiagnostic);
            }
        }
        return result;
    }

    protected static abstract class MapAssistant
    extends BasicEAnnotationValidator.Assistant {
        private final EClass dynamicAnnotationClass;
        private final List<EStructuralFeature> dynamicAnnotationFeatures;

        protected MapAssistant(@NonNull BasicEAnnotationValidator eAnnotationValidator, String className) {
            super(eAnnotationValidator);
            XMIResourceImpl dynamicAnnotationResource = new XMIResourceImpl(URI.createURI((String)PivotAnnotationsPackage.eINSTANCE.getNsURI()));
            EPackage dynamicAnnotationPackage = EcoreFactory.eINSTANCE.createEPackage();
            dynamicAnnotationPackage.setName(PivotAnnotationsPackage.eINSTANCE.getName());
            dynamicAnnotationPackage.setNsPrefix(PivotAnnotationsPackage.eINSTANCE.getNsPrefix());
            dynamicAnnotationPackage.setNsURI(PivotAnnotationsPackage.eINSTANCE.getNsURI());
            dynamicAnnotationResource.getContents().add((Object)dynamicAnnotationPackage);
            this.dynamicAnnotationClass = EcoreFactory.eINSTANCE.createEClass();
            this.dynamicAnnotationClass.setName(className);
            dynamicAnnotationPackage.getEClassifiers().add((Object)this.dynamicAnnotationClass);
            this.dynamicAnnotationFeatures = this.dynamicAnnotationClass.getEStructuralFeatures();
        }

        protected abstract @NonNull EStructuralFeature createEStructuralFeature(String var1);

        public EObject createInstance(EClass eClass, EAnnotation eAnnotation) {
            this.refreshDynamicEClass(eAnnotation);
            EObject eInstance = EcoreUtil.create((EClass)this.dynamicAnnotationClass);
            for (EStructuralFeature eStructuralFeature : this.dynamicAnnotationFeatures) {
                String value = (String)eAnnotation.getDetails().get((Object)eStructuralFeature.getName());
                eInstance.eSet(eStructuralFeature, (Object)value);
            }
            return eInstance;
        }

        public Map<String, EStructuralFeature> getProperties(EModelElement eModelElement) {
            HashMap<String, EStructuralFeature> properties = new HashMap<String, EStructuralFeature>();
            EAnnotation eAnnotation = eModelElement.getEAnnotation(this.eAnnotationValidator.getAnnotationSource());
            if (eAnnotation != null) {
                this.refreshDynamicEClass(eAnnotation);
                for (String key : eAnnotation.getDetails().keySet()) {
                    properties.put(key, this.dynamicAnnotationClass.getEStructuralFeature(key));
                }
            }
            return properties;
        }

        private void refreshDynamicEClass(EAnnotation eAnnotation) {
            HashMap<String, EStructuralFeature> properties = new HashMap<String, EStructuralFeature>();
            if (eAnnotation != null) {
                String key;
                EMap details = eAnnotation.getDetails();
                int i = this.dynamicAnnotationFeatures.size();
                while (--i >= 0) {
                    EStructuralFeature eStructuralFeature = this.dynamicAnnotationFeatures.get(i);
                    key = eStructuralFeature.getName();
                    if (details.containsKey((Object)key)) {
                        properties.put(key, eStructuralFeature);
                        continue;
                    }
                    this.dynamicAnnotationFeatures.remove(i);
                }
                for (Map.Entry detail : details) {
                    key = (String)detail.getKey();
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)properties.get(key);
                    if (eStructuralFeature != null) continue;
                    eStructuralFeature = this.createEStructuralFeature(key);
                    this.dynamicAnnotationFeatures.add(eStructuralFeature);
                    properties.put(key, eStructuralFeature);
                }
            }
        }
    }
}

