/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Library;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;

public class OCLAdapter
extends EnvironmentFactoryAdapter
implements AdapterFactory,
IDisposable {
    protected OCL ocl;

    public static @NonNull EnvironmentFactoryInternal createEnvironmentFactory(@NonNull ProjectManager projectManager, @NonNull Notifier notifier) {
        OCLInternal ocl = OCLInternal.newInstance(projectManager, null);
        OCLAdapter adapter = new OCLAdapter(ocl, notifier);
        notifier.eAdapters().add((Object)adapter);
        return adapter.getEnvironmentFactory();
    }

    public static @NonNull EnvironmentFactoryInternal createEnvironmentFactory(@NonNull Notifier notifier) {
        return OCLAdapter.createEnvironmentFactory(BasicProjectManager.createDefaultProjectManager(), notifier);
    }

    public static @NonNull OCLAdapter getAdapter(@NonNull ResourceSet resourceSet) {
        @NonNull EList eAdapters = resourceSet.eAdapters();
        OCLAdapter oclAdapter = ClassUtil.getAdapter(OCLAdapter.class, (List<Adapter>)eAdapters);
        if (oclAdapter == null) {
            EnvironmentFactoryAdapter environmentFactoryAdapter = ClassUtil.getAdapter(EnvironmentFactoryAdapter.class, (Notifier)resourceSet);
            if (environmentFactoryAdapter != null) {
                oclAdapter = new OCLAdapter(OCLInternal.newInstance(environmentFactoryAdapter.getEnvironmentFactory()), (Notifier)resourceSet);
            } else {
                OCLInternal ocl = OCLInternal.newInstance(BasicProjectManager.createDefaultProjectManager(), resourceSet);
                oclAdapter = new OCLAdapter(ocl, (Notifier)resourceSet);
            }
            eAdapters.add(oclAdapter);
        }
        return oclAdapter;
    }

    protected OCLAdapter(@NonNull OCLInternal ocl, @NonNull Notifier notifier) {
        super(ocl.getEnvironmentFactory(), notifier);
        AdapterFactory adapterFactory;
        EditingDomain editingDomain;
        this.ocl = ocl;
        if (notifier instanceof IEditingDomainProvider && (editingDomain = ((IEditingDomainProvider)notifier).getEditingDomain()) instanceof AdapterFactoryEditingDomain && (adapterFactory = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory()) instanceof ComposedAdapterFactory) {
            ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)adapterFactory;
            composedAdapterFactory.addAdapterFactory((AdapterFactory)this);
        }
    }

    public Adapter adapt(Notifier target, Object type) {
        return null;
    }

    public Object adapt(Object object, Object type) {
        return null;
    }

    public void adaptAllNew(Notifier notifier) {
    }

    public Adapter adaptNew(Notifier target, Object type) {
        return null;
    }

    public void dispose() {
        this.notifier.eAdapters().remove((Object)this);
    }

    public boolean isFactoryForType(Object type) {
        return super.isAdapterForType(type) || type == OCLAdapter.class;
    }

    @Override
    public void unsetTarget(Notifier oldTarget) {
        super.unsetTarget(oldTarget);
        OCL ocl2 = this.ocl;
        if (ocl2 != null) {
            this.ocl = null;
            if (this.notifier instanceof IEditingDomainProvider) {
                for (Adapter eAdapter : this.notifier.eAdapters()) {
                    if (!(eAdapter instanceof EContentAdapter)) continue;
                    for (Library asLibrary : ((PivotMetamodelManager)ocl2.getMetamodelManager()).getLibraries()) {
                        Resource resource = asLibrary.eResource();
                        if (resource == null || resource.getResourceSet() != null) continue;
                        resource.eAdapters().remove((Object)eAdapter);
                    }
                }
            }
            ocl2.dispose();
        }
    }
}

