/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ocl.examples.eventmanager.util.StatisticsImpl;
import org.eclipse.ocl.examples.eventmanager.util.StatisticsStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statistics {
    private static Statistics instance;

    public static Statistics getInstance() {
        if (instance == null) {
            String sysProp = System.getProperty("org.eclipse.ocl.examples.impactanalyzer.statistics");
            instance = sysProp != null && (sysProp.toLowerCase().equals("true") || sysProp.toLowerCase().equals("yes")) ? new StatisticsImpl() : new StatisticsStub();
        }
        return instance;
    }

    public abstract void begin(String var1, Object var2);

    public abstract void end(String var1, Object var2);

    public abstract void record(String var1, Object var2, long var3);

    public abstract List<Record> getRecords(String var1);

    public abstract Set<String> getGroupIds();

    public abstract void clear();

    public double getAverage(String groupId) {
        int count = 0;
        long sum = 0L;
        if (this.getRecords(groupId) != null) {
            for (Record r : this.getRecords(groupId)) {
                sum += r.getValue();
                ++count;
            }
            return (double)sum / (double)count;
        }
        return 0.0;
    }

    public String averageAsSV(String columnSeparator) {
        StringBuilder result = new StringBuilder();
        for (String groupId : this.getGroupIds()) {
            result.append(groupId);
            result.append(columnSeparator);
            result.append(this.getAverage(groupId));
            result.append('\n');
        }
        return result.toString();
    }

    public String averageAsCVS() {
        return this.averageAsSV(", ");
    }

    public Map<String, String> asCSVMapByGroupId() {
        return this.asSVMapByGroupId(", ");
    }

    public Map<String, String> asSVMapByGroupId(String columnSeparator) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String groupId : this.getGroupIds()) {
            StringBuilder sb = new StringBuilder();
            for (Record r : this.getRecords(groupId)) {
                sb.append(r.getKey());
                sb.append(columnSeparator);
                sb.append(r.getValue());
                sb.append('\n');
            }
            result.put(groupId, sb.toString());
        }
        return result;
    }

    public String asSV(String columnSeparator) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.asSVMapByGroupId(columnSeparator).entrySet()) {
            result.append(entry.getKey());
            result.append(columnSeparator);
            result.append(entry.getValue());
        }
        return result.toString();
    }

    public String asCSV() {
        return this.asSV(", ");
    }

    public static class Record {
        private Object key;
        private long value;

        public Record(Object key, long timeInNanoSeconds) {
            this.key = key;
            this.value = timeInNanoSeconds;
        }

        public Object getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }
    }
}

