/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.common.ui.internal.preferences;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.common.ui.internal.messages.CommonUIMessages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class AbstractProjectPreferencePage
extends PreferencePage
implements IPropertyChangeListener,
IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    protected static final String[][] BOOLEANS = new String[][]{{CommonUIMessages.Preference_False, Boolean.FALSE.toString()}, {CommonUIMessages.Preference_True, Boolean.TRUE.toString()}};
    protected static final String[][] ANY_LESS_VALUES = new String[][]{{CommonUIMessages.Preference_Null, Boolean.FALSE.toString()}, {CommonUIMessages.Preference_Invalid, Boolean.TRUE.toString()}};
    private static final InstanceScope INSTANCE_SCOPE_INSTANCE = new InstanceScope();
    private String pluginId;
    private List<IFieldEditor> fields = new ArrayList<IFieldEditor>();
    private IFieldEditor invalidFieldEditor = null;
    private Composite fieldEditorParent;
    private IProject project;
    private IPersistentPreferenceStore projectStore;
    private Button projectSpecificSettingsButton;
    private Link configureLink;
    private boolean initialized = false;

    public AbstractProjectPreferencePage(String pluginId, String pageTitle) {
        this.pluginId = pluginId;
        if (pluginId != null) {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)INSTANCE_SCOPE_INSTANCE, pluginId));
        }
        this.setDescription(pageTitle);
    }

    protected void adjustGridLayout() {
        int numColumns;
        ((GridLayout)this.fieldEditorParent.getLayout()).numColumns = numColumns = this.calcNumberOfColumns();
        for (IFieldEditor field : this.fields) {
            field.adjustForNumColumns(numColumns);
        }
    }

    private int calcNumberOfColumns() {
        int result = 0;
        for (IFieldEditor field : this.fields) {
            result = Math.max(result, field.getNumberOfControls());
        }
        return result;
    }

    protected void checkState() {
        boolean valid = true;
        this.invalidFieldEditor = null;
        for (IFieldEditor field : this.fields) {
            boolean bl = valid = valid && field.isValid();
            if (valid) continue;
            this.invalidFieldEditor = field;
            break;
        }
        this.setValid(valid);
    }

    protected abstract AbstractProjectPreferencePage createClonePage();

    protected Control createContents(Composite parent) {
        if (this.project != null) {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)new GridData(768));
            this.projectSpecificSettingsButton = new Button(comp, 32);
            this.projectSpecificSettingsButton.setText(CommonUIMessages.EnableProjectSpecificSettings);
            this.projectSpecificSettingsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractProjectPreferencePage.this.updateFieldEditors();
                }
            });
            this.projectSpecificSettingsButton.setLayoutData((Object)new GridData(4, 4, true, false));
            this.configureLink = this.createLink(comp, CommonUIMessages.ConfigureWorkspaceSettings);
            this.configureLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        }
        this.fieldEditorParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.fieldEditorParent.setLayout((Layout)layout);
        this.fieldEditorParent.setFont(parent.getFont());
        this.createFieldEditors(this.fieldEditorParent);
        this.adjustGridLayout();
        this.initialize();
        this.checkState();
        return this.fieldEditorParent;
    }

    public void createFieldEditors(Composite fieldEditorParent) {
        this.createFieldEditors(fieldEditorParent, this.fields);
    }

    protected abstract void createFieldEditors(Composite var1, List<IFieldEditor> var2);

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractProjectPreferencePage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractProjectPreferencePage.this.doLinkActivated((Link)e.widget);
            }
        });
        return link;
    }

    public void dispose() {
        super.dispose();
        for (IFieldEditor field : this.fields) {
            field.setPage(null);
            field.setPropertyChangeListener(null);
            field.setPreferenceStore(null);
        }
    }

    final void doLinkActivated(Link link) {
        AbstractProjectPreferencePage page = this.createClonePage();
        page.setTitle(this.getTitle());
        PreferenceNode targetNode = new PreferenceNode(this.pluginId, (IPreferencePage)page);
        PreferenceManager manager = new PreferenceManager();
        manager.addToRoot((IPreferenceNode)targetNode);
        final PreferenceDialog dialog = new PreferenceDialog(this.getControl().getShell(), manager);
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)new Runnable((IPreferenceNode)targetNode){
            private final /* synthetic */ IPreferenceNode val$targetNode;
            {
                this.val$targetNode = iPreferenceNode;
            }

            @Override
            public void run() {
                dialog.create();
                dialog.setMessage(this.val$targetNode.getLabelText());
                dialog.open();
            }
        });
    }

    public final IProject getElement() {
        return this.project;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.project == null) {
            return this.getWorkspaceStore();
        }
        if (!this.initialized) {
            return this.projectStore;
        }
        if (!this.projectSpecificSettingsButton.getSelection()) {
            return this.getWorkspaceStore();
        }
        return this.projectStore;
    }

    public IPreferenceStore getWorkspaceStore() {
        return super.getPreferenceStore();
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        if (this.project != null) {
            IPreferenceStore workspaceStore = this.getWorkspaceStore();
            IEclipsePreferences preferenceNode = new ProjectScope(this.project).getNode(this.pluginId);
            boolean hasProjectSpecificSettings = false;
            for (IFieldEditor field : this.fields) {
                String preferenceName = field.getPreferenceName();
                String prefValue = preferenceNode.get(preferenceName, null);
                if (prefValue != null) {
                    hasProjectSpecificSettings = true;
                    continue;
                }
                this.projectStore.setValue(preferenceName, workspaceStore.getString(preferenceName));
            }
            this.projectSpecificSettingsButton.setSelection(hasProjectSpecificSettings);
        }
        for (IFieldEditor field : this.fields) {
            field.setPage((DialogPage)this);
            field.setPropertyChangeListener(this);
            field.setPreferenceStore(this.getPreferenceStore());
            field.load();
        }
        this.initialized = true;
        if (this.project != null) {
            this.updateFieldEditors();
        }
    }

    protected void performDefaults() {
        String preferenceName;
        IPreferenceStore workspaceStore = this.getWorkspaceStore();
        if (this.project == null) {
            for (IFieldEditor field : this.fields) {
                preferenceName = field.getPreferenceName();
                workspaceStore.setValue(preferenceName, workspaceStore.getDefaultString(preferenceName));
            }
        } else {
            for (IFieldEditor field : this.fields) {
                preferenceName = field.getPreferenceName();
                this.projectStore.setValue(preferenceName, workspaceStore.getString(preferenceName));
            }
        }
        for (IFieldEditor field : this.fields) {
            field.loadDefault();
        }
        this.checkState();
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.project != null && !this.projectSpecificSettingsButton.getSelection()) {
            for (IFieldEditor field : this.fields) {
                String preferenceName = field.getPreferenceName();
                this.projectStore.setValue(preferenceName, this.projectStore.getDefaultString(preferenceName));
                field.loadDefault();
            }
        }
        for (IFieldEditor field : this.fields) {
            field.store();
            field.setPresentsDefaultValue(false);
        }
        if (this.project != null) {
            try {
                if (this.projectStore.needsSaving()) {
                    this.projectStore.save();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                this.checkState();
            } else {
                this.invalidFieldEditor = (IFieldEditor)event.getSource();
                this.setValid(newValue);
            }
        }
    }

    public void setElement(IAdaptable element) {
        IProject adapter;
        this.project = adapter = (IProject)element.getAdapter(IProject.class);
        if (this.project != null) {
            this.projectStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.project), this.pluginId);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.invalidFieldEditor != null) {
            this.invalidFieldEditor.setFocus();
        }
    }

    protected void updateFieldEditors() {
        boolean enabled = this.projectSpecificSettingsButton.getSelection();
        for (IFieldEditor field : this.fields) {
            field.setEnabled(enabled, this.fieldEditorParent);
        }
        this.configureLink.setEnabled(enabled);
    }

    protected static interface IFieldEditor {
        public void adjustForNumColumns(int var1);

        public int getNumberOfControls();

        public String getPreferenceName();

        public boolean isValid();

        public void load();

        public void loadDefault();

        public void setEnabled(boolean var1, Composite var2);

        public void setFocus();

        public void setPage(DialogPage var1);

        public void setPreferenceStore(IPreferenceStore var1);

        public void setPresentsDefaultValue(boolean var1);

        public void setPropertyChangeListener(IPropertyChangeListener var1);

        public void store();
    }

    protected static class MyComboFieldEditor
    extends ComboFieldEditor
    implements IFieldEditor {
        public MyComboFieldEditor(PreferenceableOption<?> preference, String labelText, String[][] entryNamesAndValues, Composite parent) {
            super(preference.getKey(), labelText, entryNamesAndValues, parent);
        }

        @Override
        public void adjustForNumColumns(int numColumns) {
            super.adjustForNumColumns(numColumns);
        }

        @Override
        public void setPresentsDefaultValue(boolean booleanValue) {
            super.setPresentsDefaultValue(booleanValue);
        }
    }
}

