/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.richtext.RichTextEditor;
import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.JavaCallbackListener;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class RichTextCellEditor
extends AbstractCellEditor {
    private static final Log LOG = LogFactory.getLog(RichTextCellEditor.class);
    protected RichTextEditor editor = null;
    protected RichTextEditorConfiguration editorConfiguration;
    @Deprecated
    protected ToolbarConfiguration toolbarConfiguration;
    protected int style;

    public RichTextCellEditor() {
        this((RichTextEditorConfiguration)null, 16);
    }

    @Deprecated
    public RichTextCellEditor(ToolbarConfiguration toolbarConfiguration) {
        this(toolbarConfiguration, 16);
    }

    public RichTextCellEditor(RichTextEditorConfiguration editorConfiguration) {
        this(editorConfiguration, 16);
    }

    public RichTextCellEditor(int style) {
        this((RichTextEditorConfiguration)null, style);
    }

    @Deprecated
    public RichTextCellEditor(ToolbarConfiguration toolbarConfiguration, int style) {
        this((RichTextEditorConfiguration)null, style);
        this.toolbarConfiguration = toolbarConfiguration;
        try {
            Constructor declaredConstructor = RichTextEditorConfiguration.class.getDeclaredConstructor(ToolbarConfiguration.class);
            declaredConstructor.setAccessible(true);
            this.editorConfiguration = (RichTextEditorConfiguration)declaredConstructor.newInstance(toolbarConfiguration);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOG.error((Object)"Error on creating RichTextCellEditor with ToolbarConfiguration", (Throwable)e);
        }
    }

    public RichTextCellEditor(RichTextEditorConfiguration editorConfiguration, int style) {
        if (editorConfiguration == null) {
            editorConfiguration = new RichTextEditorConfiguration();
            editorConfiguration.setToolbarCollapsible(true);
            editorConfiguration.setToolbarInitialExpanded(true);
        }
        this.editorConfiguration = editorConfiguration;
        this.style = style | 0x1000000;
    }

    public Object getEditorValue() {
        return this.editor.getText();
    }

    public void setEditorValue(Object value) {
        this.editor.setText(value != null ? (String)value : "");
    }

    public RichTextEditor getEditorControl() {
        return this.editor;
    }

    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        this.editor = this.createEditorControl(parent);
        this.setCanonicalValue(originalCanonicalValue);
        this.editor.forceFocus();
        return this.editor;
    }

    public RichTextEditor createEditorControl(Composite parent) {
        this.editor = this.createRichTextEditor(parent);
        this.editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    RichTextCellEditor.this.close();
                }
                if (e.keyCode == 13 && e.stateMask == SWT.MOD1) {
                    RichTextCellEditor.this.commit(SelectionLayer.MoveDirectionEnum.NONE);
                }
            }
        });
        this.editor.addJavaCallbackListener(new JavaCallbackListener(){

            public void javaExecutionStarted() {
                if (RichTextCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((RichTextCellEditor)RichTextCellEditor.this).focusListener).handleFocusChanges = false;
                }
            }

            public void javaExecutionFinished() {
                if (RichTextCellEditor.this.focusListener instanceof AbstractCellEditor.InlineFocusListener) {
                    ((AbstractCellEditor.InlineFocusListener)((RichTextCellEditor)RichTextCellEditor.this).focusListener).handleFocusChanges = true;
                }
            }
        });
        return this.editor;
    }

    protected RichTextEditor createRichTextEditor(Composite parent) {
        return new RichTextEditor(parent, this.editorConfiguration, this.style){

            protected int getMinimumHeight() {
                return RichTextCellEditor.this.getMinimumDimension().y;
            }

            protected int getMinimumWidth() {
                return RichTextCellEditor.this.getMinimumDimension().x;
            }
        };
    }

    protected Point getMinimumDimension() {
        return new Point(370, 200);
    }
}

