/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.widget;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WaitDialog
extends Dialog {
    private String msg;
    private Image iconImage;
    private Label textLabel;

    public WaitDialog(Shell parent, int shellStyle, String msg, Image iconImg) {
        super(parent);
        this.msg = msg;
        this.iconImage = iconImg;
        this.setShellStyle(shellStyle | 0x10000);
    }

    private void centerDialogOnScreen(Shell shell) {
        shell.setSize(250, 75);
        Rectangle parentSize = this.getParentShell().getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(locationX, locationY);
    }

    protected Control createContents(Composite parent) {
        this.centerDialogOnScreen(this.getShell());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(2, 2, true, true));
        composite.setRedraw(true);
        Label imgLabel = new Label(composite, 0);
        imgLabel.setImage(this.iconImage);
        this.textLabel = new Label(composite, 0);
        this.textLabel.setLayoutData((Object)new GridData(2, 2, true, true));
        this.textLabel.setFont(GUIHelper.getFont(new FontData("Arial", 9, 1)));
        this.textLabel.setRedraw(true);
        this.textLabel.setText(this.msg);
        return composite;
    }

    public void setMsg(String msg) {
        this.msg = msg;
        this.textLabel.setText(msg);
        this.getShell().layout(new Control[]{this.textLabel});
    }

    public boolean close() {
        if (ObjectUtils.isNotNull(this.iconImage)) {
            this.iconImage.dispose();
        }
        return super.close();
    }
}

