/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.mode;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.ui.mode.IModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;

public class AbstractModeEventHandler
implements IModeEventHandler {
    private ModeSupport modeSupport;
    protected final NatTable natTable;

    public AbstractModeEventHandler(ModeSupport modeSupport, NatTable natTable) {
        this.modeSupport = modeSupport;
        this.natTable = natTable;
    }

    protected ModeSupport getModeSupport() {
        return this.modeSupport;
    }

    protected void switchMode(String mode) {
        this.modeSupport.switchMode(mode);
    }

    protected void switchMode(IModeEventHandler modeEventHandler) {
        this.modeSupport.switchMode(modeEventHandler);
    }

    @Override
    public void cleanup() {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseUp(MouseEvent event) {
    }

    public void mouseMove(MouseEvent event) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    public void focusGained(FocusEvent event) {
    }

    public void focusLost(FocusEvent event) {
        this.switchMode("NORMAL_MODE");
    }

    @Deprecated
    protected boolean eventOnSameCell(MouseEvent downEvent, MouseEvent upEvent) {
        int startCol = this.natTable.getColumnPositionByX(downEvent.x);
        int startRow = this.natTable.getRowPositionByY(downEvent.y);
        int col = this.natTable.getColumnPositionByX(upEvent.x);
        int row = this.natTable.getRowPositionByY(upEvent.y);
        return startCol == col && startRow == row;
    }
}

