/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.function;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractMathFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;

public class ProductFunction
extends AbstractMathFunction {
    public ProductFunction() {
    }

    public ProductFunction(List<FunctionValue> values) {
        super(values);
    }

    @Override
    public BigDecimal getValue() {
        if (this.values.isEmpty()) {
            return new BigDecimal(0);
        }
        BigDecimal result = null;
        for (FunctionValue value : this.values) {
            result = result == null ? this.convertValue(value.getValue()) : result.multiply(this.convertValue(value.getValue()));
        }
        return result;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "*";
        }
        if (this.values.size() == 1) {
            return "* " + this.values.get(0);
        }
        StringBuilder builder = new StringBuilder();
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            FunctionValue v = (FunctionValue)it.next();
            builder.append(v);
            if (!it.hasNext()) continue;
            builder.append(" * ");
        }
        return builder.toString();
    }
}

