/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;

public abstract class AbstractSearchHandler {
    private final List<IFilterChangeListener> listeners = new ArrayList<IFilterChangeListener>();

    public void addFilterChangeListener(IFilterChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeFilterChangeListener(IFilterChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireFilterChanged() {
        if (this.listeners.isEmpty()) {
            return;
        }
        IFilterChangeListener[] iFilterChangeListenerArray = this.listeners.toArray(new IFilterChangeListener[this.listeners.size()]);
        int n = iFilterChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFilterChangeListener listener = iFilterChangeListenerArray[n2];
            listener.filterChanged();
            ++n2;
        }
    }

    public abstract Composite createSearchComposite(Composite var1);

    public abstract PatternFilter createFilter();

    public abstract void dispose();

    public void adaptTextSearchControl(Text textControl) {
    }

    public static interface IFilterChangeListener {
        public void filterChanged();
    }
}

