/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BrowserPreviewViewer {
    private Browser browser;
    private boolean ignoreLocationEvents;
    private final AbstractRenderingEngine renderingEngine;
    private final TaskRepository taskRepository;

    public BrowserPreviewViewer(TaskRepository taskRepository, AbstractRenderingEngine renderingEngine) {
        Assert.isNotNull((Object)taskRepository);
        Assert.isNotNull((Object)renderingEngine);
        this.taskRepository = taskRepository;
        this.renderingEngine = renderingEngine;
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        this.browser = new Browser(parent, 0);
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (BrowserPreviewViewer.this.ignoreLocationEvents) {
                    return;
                }
                if (event.location != null && !event.location.startsWith("about")) {
                    event.doit = false;
                    BrowserUtil.openUrl((String)event.location);
                }
            }
        });
    }

    public Browser getControl() {
        return this.browser;
    }

    private void previewWiki(final Browser browser, String sourceText) {
        final class PreviewWikiJob
        extends Job {
            private String htmlText;
            private IStatus jobStatus;
            private final String sourceText;

            public PreviewWikiJob(String sourceText) {
                super(Messages.BrowserPreviewViewer_Formatting_Wiki_Text);
                if (sourceText == null) {
                    throw new IllegalArgumentException("source text must not be null");
                }
                this.sourceText = sourceText;
            }

            public String getHtmlText() {
                return this.htmlText;
            }

            public IStatus getStatus() {
                return this.jobStatus;
            }

            protected IStatus run(IProgressMonitor monitor) {
                if (BrowserPreviewViewer.this.renderingEngine == null) {
                    this.jobStatus = new RepositoryStatus(BrowserPreviewViewer.this.taskRepository, 1, "org.eclipse.mylyn.tasks.ui", 7, Messages.BrowserPreviewViewer_The_repository_does_not_support_HTML_preview);
                    return Status.OK_STATUS;
                }
                this.jobStatus = Status.OK_STATUS;
                try {
                    this.htmlText = BrowserPreviewViewer.this.renderingEngine.renderAsHtml(BrowserPreviewViewer.this.taskRepository, this.sourceText, monitor);
                }
                catch (CoreException e) {
                    this.jobStatus = e.getStatus();
                }
                return Status.OK_STATUS;
            }
        }
        final PreviewWikiJob job = new PreviewWikiJob(sourceText);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            {
            }

            public void done(IJobChangeEvent event) {
                if (!browser.isDisposed()) {
                    if (job.getStatus().isOK()) {
                        browser.getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            @Override
                            public void run() {
                                BrowserPreviewViewer.this.setText(browser, job.getHtmlText());
                            }
                        });
                    } else {
                        browser.getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            @Override
                            public void run() {
                                TasksUiInternal.displayStatus(Messages.BrowserPreviewViewer_Error, job.getStatus());
                            }
                        });
                    }
                }
                super.done(event);
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private void setText(Browser browser, String html) {
        try {
            this.ignoreLocationEvents = true;
            browser.setText(html != null ? html : "");
        }
        finally {
            this.ignoreLocationEvents = false;
        }
    }

    public void update(String value) {
        this.setText(this.browser, Messages.BrowserPreviewViewer_Loading_preview_);
        this.previewWiki(this.browser, value);
    }
}

