/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskInitializationData;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CloneTaskAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private static final String ID = "org.eclipse.mylyn.tasklist.actions.clone";
    protected ISelection selection;

    public CloneTaskAction() {
        super(Messages.CloneTaskAction_Clone_Label);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
    }

    public void init(IViewPart view) {
    }

    public void run() {
        for (Object selectedObject : this.getStructuredSelection().toList()) {
            TaskData taskData;
            String notes;
            if (!(selectedObject instanceof AbstractTask)) continue;
            AbstractTask task = (AbstractTask)selectedObject;
            String description = String.valueOf(Messages.CloneTaskAction_Cloned_from_) + CopyTaskDetailsAction.getTextForTask(task);
            if (task instanceof LocalTask && !"".equals(notes = task.getNotes())) {
                description = String.valueOf(description) + "\n\n" + notes;
            }
            TaskInitializationData initializationData = new TaskInitializationData();
            initializationData.setDescription(description);
            try {
                taskData = TasksUi.getTaskDataManager().getTaskData((ITask)task);
            }
            catch (CoreException e) {
                TasksUiInternal.displayStatus(Messages.CloneTaskAction_Clone_Task_Failed, e.getStatus());
                continue;
            }
            ITaskMapping taskSelection = this.getTaskMapping(initializationData, taskData);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (TasksUiUtil.openNewTaskEditor(shell, taskSelection, null)) continue;
            return;
        }
    }

    public ITaskMapping getTaskMapping(TaskInitializationData initializationData, TaskData taskData) {
        if (taskData != null) {
            AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector(taskData.getConnectorKind());
            ITaskMapping mapping = connector.getTaskMapping(taskData);
            if (mapping.getDescription() != null) {
                initializationData.setDescription(String.valueOf(initializationData.getDescription()) + "\n\n" + mapping.getDescription());
                TaskAttribute attrDescription = mapping.getTaskData().getRoot().getMappedAttribute("task.common.description");
                if (attrDescription != null) {
                    attrDescription.getMetaData().setReadOnly(false);
                }
            }
            mapping.merge((ITaskMapping)initializationData);
            return mapping;
        }
        return initializationData;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            super.selectionChanged((IStructuredSelection)selection);
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object element : selection.toList()) {
                if (element instanceof AbstractTask) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

