/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public final class ReviewUiUtil {
    public static final String CONFLUENCE_WIKI_TASK_EDITOR_EXTENSION = "org.eclipse.mylyn.wikitext.tasks.ui.editor.confluenceTaskEditorExtension";

    private ReviewUiUtil() {
    }

    public static boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public static boolean ensureViewIsVisible(String viewId) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            if (view.getId().equals(viewId)) {
                return true;
            }
            ++n2;
        }
        try {
            activePage.showView(viewId, null, 1);
            return true;
        }
        catch (PartInitException e) {
            return false;
        }
    }

    public static boolean showViewInActiveWorkbenchPage(String viewId) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return false;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return false;
        }
        try {
            activePage.showView(viewId);
            return true;
        }
        catch (PartInitException e) {
            return false;
        }
    }

    public static LineRange getSelectedLineNumberRangeFromEditorInput(IEditorPart editor, IEditorInput editorInput) {
        if (editor instanceof ITextEditor && editor.getEditorInput() == editorInput) {
            ISelection selection = ((ITextEditor)editor).getSelectionProvider().getSelection();
            return ReviewUiUtil.getLineRange(selection);
        }
        if (editor.getAdapter(ITextEditor.class) != null) {
            ISelection selection = ((ITextEditor)editor.getAdapter(ITextEditor.class)).getSelectionProvider().getSelection();
            return ReviewUiUtil.getLineRange(selection);
        }
        return null;
    }

    private static LineRange getLineRange(ISelection selection) {
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            return new LineRange(textSelection.getStartLine() + 1, textSelection.getEndLine() - textSelection.getStartLine() + 1);
        }
        return null;
    }

    public static Display getDisplay(Shell shell) {
        Display d;
        if (shell != null && (d = shell.getDisplay()) != null) {
            return d;
        }
        return ReviewUiUtil.getDisplay();
    }

    public static Display getDisplay() {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        if (d == null) {
            d = WorkbenchUtil.getShell().getDisplay();
        }
        return d;
    }

    public static boolean isAnonymous(IReviewItem item) {
        return item != null && ReviewUiUtil.isAnonymous(item.getReview());
    }

    public static boolean isAnonymous(IReview review) {
        return review != null && review.getRepository() != null && review.getRepository().getAccount() == null;
    }
}

