/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.core.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class InteractionByTypeSummary {
    HashMap<String, HashMap<Integer, Integer>> usageMap = new HashMap();

    public void setUserCount(int userId, String originId, int count) {
        if (!this.usageMap.containsKey(originId)) {
            this.usageMap.put(originId, new HashMap());
        }
        this.usageMap.get(originId).put(userId, count);
    }

    public int getUserCount(int userId, String originId) {
        if (this.usageMap.containsKey(originId) && this.usageMap.get(originId).containsKey(userId)) {
            return this.usageMap.get(originId).get(userId);
        }
        return 0;
    }

    public int getTotalCount(String originId) {
        int count = 0;
        for (Integer userId : this.usageMap.get(originId).keySet()) {
            count += this.usageMap.get(originId).get(userId).intValue();
        }
        return count;
    }

    public void printOut(Set<Integer> allUserIdsList) {
        System.out.print("EventId");
        for (Integer userId : allUserIdsList) {
            System.out.print("\t" + userId);
        }
        System.out.println();
        for (String originId : this.usageMap.keySet()) {
            System.out.print(originId);
            Set<Integer> userIdSet = this.usageMap.get(originId).keySet();
            for (int userId : allUserIdsList) {
                if (userIdSet.contains(userId)) {
                    System.out.print("\t1");
                    continue;
                }
                System.out.print("\t0");
            }
            System.out.println();
        }
    }

    public ArrayList<String> getOriginIdList() {
        ArrayList<String> originIdList = new ArrayList<String>(this.usageMap.keySet());
        return originIdList;
    }
}

