/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.mylyn.internal.bugzilla.ui.editor.Messages;
import org.eclipse.mylyn.internal.tasks.core.TaskComment;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorCommentPart;
import org.eclipse.mylyn.tasks.core.ITaskComment;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;

public class BugzillaTaskEditorCommentPart
extends TaskEditorCommentPart {
    protected void addActionsToToolbarTitle(ToolBarManager toolBarManager, TaskComment taskComment, TaskEditorCommentPart.CommentViewer commentViewer) {
        String insidergroup = this.getModel().getTaskRepository().getProperty("bugzilla.insider.group");
        if (Boolean.parseBoolean(insidergroup)) {
            LockAction lockAction = new LockAction((ITaskComment)taskComment);
            toolBarManager.add((IAction)lockAction);
        }
    }

    private class LockAction
    extends Action {
        private final ITaskComment taskComment;

        public LockAction(ITaskComment taskComment) {
            this.taskComment = taskComment;
            this.updateActionState();
        }

        private void updateActionState() {
            if (this.taskComment.getIsPrivate() != null) {
                if (this.taskComment.getIsPrivate().booleanValue()) {
                    this.setImageDescriptor(TasksUiImages.LOCK_CLOSE);
                    this.setToolTipText(Messages.BugzillaTaskEditorCommentPart_privateComment);
                } else {
                    this.setImageDescriptor(TasksUiImages.LOCK_OPEN);
                    this.setToolTipText(Messages.BugzillaTaskEditorCommentPart_publicComment);
                }
            }
        }

        public void run() {
            if (this.taskComment.getIsPrivate() != null) {
                TaskAttribute isPrivate;
                this.taskComment.setIsPrivate(Boolean.valueOf(this.taskComment.getIsPrivate() == false));
                TaskAttribute isprivate = this.taskComment.getTaskAttribute().getMappedAttribute("task.common.comment.isprivate");
                if (isprivate == null) {
                    isprivate = this.taskComment.getTaskAttribute().createMappedAttribute("task.common.comment.isprivate");
                }
                isprivate.setValue(this.taskComment.getIsPrivate() != false ? "1" : "0");
                String value = this.taskComment.getTaskAttribute().getValue();
                TaskAttribute definedIsPrivate = this.taskComment.getTaskAttribute().getAttribute("defined_isprivate_" + value);
                if (definedIsPrivate == null) {
                    definedIsPrivate = this.taskComment.getTaskAttribute().createAttribute("defined_isprivate_" + value);
                }
                if ((isPrivate = this.taskComment.getTaskAttribute().getAttribute("isprivate_" + value)) == null) {
                    isPrivate = this.taskComment.getTaskAttribute().createAttribute("isprivate_" + value);
                }
                definedIsPrivate.setValue("1");
                isPrivate.setValue(this.taskComment.getIsPrivate() != false ? "1" : "0");
                BugzillaTaskEditorCommentPart.this.getModel().attributeChanged(this.taskComment.getTaskAttribute());
                this.updateActionState();
            }
        }
    }
}

