/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.common.core.internal.utils;

import com.ibm.icu.lang.UCharacter;
import org.eclipse.modisco.infra.common.core.internal.Messages;

public final class StringUtils {
    public static final String ELLIPSIS = Messages.StringUtils_ellipsis;
    private static final int TRUNCATE_AFTER = 150;

    private StringUtils() {
    }

    public static String firstLetterToLowerCase(String source) {
        String result = source.length() == 0 ? source : (source.length() == 1 ? source.toLowerCase() : String.valueOf(source.substring(0, 1).toLowerCase()) + source.substring(1));
        return result;
    }

    public static String firstLetterToUpperCase(String source) {
        String result = source.length() == 0 ? source : (source.length() == 1 ? source.toUpperCase() : String.valueOf(source.substring(0, 1).toUpperCase()) + source.substring(1));
        return result;
    }

    public static String truncateBeforeNewline(String str) {
        int endIndex = str.indexOf(13);
        if (endIndex == -1) {
            endIndex = str.indexOf(10);
        }
        if (endIndex != -1 && endIndex <= 150) {
            return String.valueOf(str.substring(0, endIndex)) + ELLIPSIS;
        }
        if (endIndex == -1) {
            endIndex = str.length();
        }
        if (endIndex > 150) {
            return String.valueOf(str.substring(0, 75)) + ELLIPSIS + str.substring(endIndex - 75, endIndex);
        }
        return str;
    }

    public static String inferJavaClassName(String name) {
        String upperName = StringUtils.firstLetterToUpperCase(name.trim());
        StringBuilder javaName = new StringBuilder();
        boolean space = false;
        int i = 0;
        while (i < upperName.length()) {
            char c = upperName.charAt(i);
            if (c == ' ') {
                space = true;
            } else if (space) {
                javaName.append(UCharacter.toUpperCase((int)c));
                space = false;
            } else {
                javaName.append(c);
            }
            ++i;
        }
        return javaName.toString();
    }

    public static String escape(String str, char escapeChar, char[] charsToEscape, char[] replacementChars) {
        if (charsToEscape.length != replacementChars.length) {
            throw new IllegalArgumentException("charsToEscape and replacementChars must have the same length");
        }
        StringBuilder builder = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            boolean escaped = false;
            int j = 0;
            while (j < charsToEscape.length) {
                if (c == charsToEscape[j]) {
                    builder.append(escapeChar).append(replacementChars[j]);
                    escaped = true;
                    break;
                }
                ++j;
            }
            if (!escaped) {
                if (c == escapeChar) {
                    builder.append(escapeChar).append(escapeChar);
                } else {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    public static String unescape(String str, char escapeChar, char[] escapedChars, char[] replacementChars) {
        if (escapedChars.length != replacementChars.length) {
            throw new IllegalArgumentException("charsToEscape and replacementChars must have the same length");
        }
        StringBuilder builder = new StringBuilder(str.length());
        boolean nextIsEscaped = false;
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (nextIsEscaped) {
                boolean unescaped = false;
                int j = 0;
                while (j < replacementChars.length) {
                    if (c == replacementChars[j]) {
                        builder.append(escapedChars[j]);
                        unescaped = true;
                        break;
                    }
                    ++j;
                }
                if (!unescaped) {
                    if (c == escapeChar) {
                        builder.append(escapeChar);
                    } else {
                        builder.append(c);
                    }
                }
                nextIsEscaped = false;
            } else if (c == escapeChar) {
                nextIsEscaped = true;
            } else {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }
}

