/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.contentAssist;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContentAssistElement;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.SuggestionProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltinSuggestionProvider
implements SuggestionProvider {
    private TreeSet<ContentAssistElement> orderedList;

    public BuiltinSuggestionProvider() {
        this.initList();
    }

    @Override
    public List<ContentAssistElement> getSuggestions(String context) {
        LinkedList<ContentAssistElement> tempList = new LinkedList<ContentAssistElement>();
        boolean foundFirst = false;
        for (ContentAssistElement cp : this.orderedList) {
            String cName = cp.getClassName();
            if (cName.startsWith(context)) {
                foundFirst = true;
                tempList.add(cp);
                continue;
            }
            if (foundFirst) break;
        }
        return tempList;
    }

    private void initList() {
        String[] builtin = new String[]{"toHex", "toString", "dominators", "dominatorof", "outbounds", "inbounds", "classof"};
        this.orderedList = new TreeSet();
        Image im = MemoryAnalyserPlugin.getImage("$nl$/icons/info.gif");
        String[] stringArray = builtin;
        int n = builtin.length;
        int n2 = 0;
        while (n2 < n) {
            String func = stringArray[n2];
            ContentAssistElement ce = new ContentAssistElement(String.valueOf(func) + "()", im);
            this.orderedList.add(ce);
            ++n2;
        }
        im = MemoryAnalyserPlugin.getImage("$nl$/icons/heapobjects/heapdump16.gif");
        ContentAssistElement ce = new ContentAssistElement("${snapshot}", im);
        this.orderedList.add(ce);
    }
}

