/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.mat.ui.snapshot.OpenSnapshot;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

public class OpenSnapshotAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        boolean successful = new OpenSnapshot.Visitor(){

            public void visit(IFileStore fileStore) {
                try {
                    IEditorInput input = OpenSnapshotAction.this.createEditorInput(fileStore);
                    IWorkbenchPage page = OpenSnapshotAction.this.fWindow.getActivePage();
                    page.openEditor(input, "org.eclipse.mat.ui.editors.HeapEditor");
                }
                catch (OperationCanceledException input) {
                }
                catch (PartInitException e) {
                    MemoryAnalyserPlugin.log(e.getStatus());
                    String msg = MessageUtil.format((String)Messages.OpenSnapshotAction_ErrorOpeningFile, (Object[])new Object[]{fileStore.getName()});
                    MessageDialog.openError((Shell)OpenSnapshotAction.this.fWindow.getShell(), (String)Messages.ErrorHelper_InternalError, (String)msg);
                }
            }
        }.go(this.getWindow().getShell());
        if (successful && PlatformUI.getWorkbench().getIntroManager().getIntro() != null) {
            PlatformUI.getWorkbench().getIntroManager().setIntroStandby(PlatformUI.getWorkbench().getIntroManager().getIntro(), true);
        }
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private IWorkbenchWindow getWindow() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.fWindow = workbench.getActiveWorkbenchWindow();
        return this.fWindow;
    }

    private IEditorInput createEditorInput(IFileStore fileStore) {
        try {
            IFile workspaceFile = this.getWorkspaceFile(fileStore);
            if (workspaceFile != null) {
                return new FileEditorInput(workspaceFile);
            }
            return new PathEditorInput((IPath)new Path(fileStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()).getAbsolutePath()));
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    private IFile getWorkspaceFile(IFileStore fileStore) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = workspace.getRoot().findFilesForLocationURI(fileStore.toURI());
        if ((files = this.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.selectWorkspaceFile(files);
    }

    private IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fWindow.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        dialog.setTitle(Messages.OpenSnapshotAction_SelectWorkspace);
        dialog.setMessage(Messages.OpenSnapshotAction_Message);
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        throw new OperationCanceledException();
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }
}

