/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class AtlColorManager
implements ISharedTextColors {
    private boolean autoDisposeOnDisplayDispose;
    protected Map<Display, Map<RGB, Color>> displayTable = new HashMap<Display, Map<RGB, Color>>();
    protected HashMap<String, RGB> keyTable = new HashMap();

    public AtlColorManager() {
        this(true);
    }

    public AtlColorManager(boolean adodd) {
        this.autoDisposeOnDisplayDispose = adodd;
    }

    public Object add(String key, RGB rgb) {
        if (this.keyTable.get(key) != null) {
            throw new UnsupportedOperationException();
        }
        return this.keyTable.put(key, rgb);
    }

    public void bindColor(String key, RGB rgb) {
        RGB value = this.keyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.keyTable.put(key, rgb);
    }

    public void dispose() {
        if (!this.autoDisposeOnDisplayDispose) {
            this.dispose(Display.getCurrent());
        }
    }

    protected void dispose(Display display) {
        Map<RGB, Color> colorTable = this.displayTable.get(display);
        if (colorTable != null) {
            for (Color color : colorTable.values()) {
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        Map<RGB, Color> colorTable = this.displayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.displayTable.put(display, colorTable);
            if (this.autoDisposeOnDisplayDispose) {
                display.disposeExec(new Runnable(){

                    public void run() {
                        AtlColorManager.this.dispose(display);
                    }
                });
            }
        }
        if ((color = colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public Color getColor(String color) {
        if (color == null) {
            return null;
        }
        return this.getColor(this.keyTable.get(color));
    }

    public Object remove(String key) {
        return this.keyTable.remove(key);
    }

    public void unbindColor(String key) {
        this.keyTable.remove(key);
    }
}

