/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;

public class ScpClient {
    private Session session;

    public ScpClient(RemoteScriptOptions remoteOptions) throws JSchException {
        JSch jsch = new JSch();
        this.session = jsch.getSession(remoteOptions.userName, remoteOptions.hostName, 22);
        this.session.setPassword(remoteOptions.password);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transfer(String fromFile, String toFile) throws IOException, JSchException {
        Channel channel;
        block25: {
            String rfile = toFile;
            String lfile = fromFile;
            String command = "scp -t " + rfile;
            channel = this.session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            Throwable throwable = null;
            Object var8_9 = null;
            try {
                OutputStream out = channel.getOutputStream();
                try {
                    try (InputStream in = channel.getInputStream();){
                        channel.connect();
                        if (ScpClient.checkAck(in) != 0) {
                            System.out.println("err");
                        }
                        long filesize = new File(lfile).length();
                        command = "C0644 " + filesize + " ";
                        command = lfile.lastIndexOf(47) > 0 ? String.valueOf(command) + lfile.substring(lfile.lastIndexOf(47) + 1) : String.valueOf(command) + lfile;
                        command = String.valueOf(command) + "\n";
                        out.write(command.getBytes());
                        out.flush();
                        if (ScpClient.checkAck(in) != 0) {
                            System.out.println("err");
                        }
                        byte[] buf = new byte[1024];
                        Throwable throwable2 = null;
                        Object var15_18 = null;
                        try (FileInputStream fis = new FileInputStream(lfile);){
                            int len;
                            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                                out.write(buf, 0, len);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            }
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                            throw throwable2;
                        }
                        buf[0] = 0;
                        out.write(buf, 0, 1);
                        out.flush();
                        if (ScpClient.checkAck(in) != 0) {
                            System.out.println("err");
                        }
                    }
                    if (out == null) break block25;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (out == null) throw throwable;
                    out.close();
                    throw throwable;
                }
                out.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        channel.disconnect();
        this.session.disconnect();
    }

    private static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }
}

