/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ConfigUtils {
    private static final String EMPTY_STRING = "";
    private ILaunchConfiguration config;

    public ConfigUtils(ILaunchConfiguration config) {
        this.config = config;
    }

    public boolean getCopyExecutable() throws CoreException {
        return this.config.getAttribute("ENABLE_COPY_FROM_EXE", false);
    }

    public String getCopyFromExecutablePath() throws CoreException {
        return this.config.getAttribute("COPY_FROM_EXE_NAME", EMPTY_STRING);
    }

    public String getExecutablePath() throws CoreException {
        return this.config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
    }

    public String getWorkingDirectory() throws CoreException {
        URI workingDirectoryURI;
        String workingDirectory = this.config.getAttribute("REMOTE_WORKING_DIRECTORY_NAME", EMPTY_STRING);
        if (workingDirectory.isEmpty()) {
            return null;
        }
        try {
            workingDirectoryURI = new URI(workingDirectory);
        }
        catch (URISyntaxException e) {
            return null;
        }
        return workingDirectoryURI.getPath();
    }

    public static IProject getProject(String project) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(project);
    }

    public IProject getProject() throws CoreException {
        return ConfigUtils.getProject(this.getProjectName());
    }

    public String getProjectName() throws CoreException {
        return ConfigUtils.getProjectName(this.config);
    }

    public static String getProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }
}

