/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch.provider.launch;

import java.text.MessageFormat;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.Messages;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.ProviderFramework;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationTabGroup;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchShortcut;
import org.eclipse.swt.widgets.MessageBox;

public class ProviderLaunchShortcut
extends ProfileLaunchShortcut
implements IExecutableExtension {
    private String type;
    private String launchConfigId;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        Map parameters = (Map)data;
        String profilingType = (String)parameters.get("type");
        String configId = (String)parameters.get("configurationId");
        if (profilingType == null) {
            profilingType = "";
        }
        if (configId == null) {
            configId = "";
        }
        this.setLaunchConfigID(configId);
        this.setProfilingType(profilingType);
    }

    @Override
    protected ILaunchConfigurationType getLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(this.getLaunchConfigID());
    }

    @Override
    protected ILaunchConfiguration findLaunchConfiguration(IBinary bin, String mode) {
        ILaunchConfiguration config = this.createConfiguration(bin, false);
        String providerId = null;
        try {
            providerId = ProviderFramework.getProviderIdToRun(config.getWorkingCopy(), this.type);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (providerId == null) {
            this.handleFail(String.valueOf(Messages.ProviderLaunchShortcut_0) + " " + this.type);
            return null;
        }
        boolean existsConfigForProject = false;
        boolean existsConfigForTool = false;
        try {
            ILaunchConfiguration[] configs;
            String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            String programName = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = this.getLaunchManager().getLaunchConfigurations(this.getLaunchConfigType());
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration currConfig = iLaunchConfigurationArray[n2];
                String curProjectName = currConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                String curProgramName = currConfig.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                if (curProjectName.equals(projectName) && curProgramName.equals(programName)) {
                    existsConfigForProject = true;
                    String curProviderId = currConfig.getAttribute("provider", "");
                    if (curProviderId.equals(providerId)) {
                        existsConfigForTool = true;
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            existsConfigForProject = true;
            existsConfigForTool = true;
        }
        if (!existsConfigForProject) {
            this.createConfiguration(bin);
        } else if (!existsConfigForTool) {
            String provider = ProviderFramework.getProviderToolNameFromId(providerId);
            String profileType = String.valueOf(Character.toUpperCase(this.type.charAt(0))) + this.type.substring(1);
            String promptMsg = MessageFormat.format(Messages.ProviderLaunchConfigurationPrompt_0, profileType, provider);
            MessageBox prompt = new MessageBox(this.getActiveWorkbenchShell(), 196);
            prompt.setMessage(promptMsg);
            if (prompt.open() == 64) {
                return this.createConfiguration(bin);
            }
        }
        return super.findLaunchConfiguration(bin, mode);
    }

    @Override
    protected void setDefaultProfileAttributes(ILaunchConfigurationWorkingCopy wc) {
        String providerId = ProviderFramework.getProviderIdToRun(wc, this.getProfilingType());
        final String providerToolName = ProviderFramework.getProviderToolNameFromId(providerId);
        ProfileLaunchConfigurationTabGroup tabgroup = ProviderFramework.getTabGroupProviderFromId(providerId);
        ILaunchConfigurationDialog dialog = new ILaunchConfigurationDialog(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) {
                throw new UnsupportedOperationException();
            }

            public void updateMessage() {
                throw new UnsupportedOperationException();
            }

            public void updateButtons() {
                throw new UnsupportedOperationException();
            }

            public void setName(String name) {
                throw new UnsupportedOperationException();
            }

            public void setActiveTab(int index) {
                throw new UnsupportedOperationException();
            }

            public void setActiveTab(ILaunchConfigurationTab tab) {
                throw new UnsupportedOperationException();
            }

            public ILaunchConfigurationTab[] getTabs() {
                return null;
            }

            public String getMode() {
                return null;
            }

            public ILaunchConfigurationTab getActiveTab() {
                return null;
            }

            public String generateName(String name) {
                if (name == null) {
                    name = "";
                }
                String providerConfigutationName = ProviderLaunchShortcut.generateProviderConfigurationName(name, providerToolName);
                return ProviderLaunchShortcut.this.getLaunchManager().generateLaunchConfigurationName(providerConfigutationName);
            }
        };
        tabgroup.createTabs(dialog, "profile");
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabgroup.getTabs();
        int n = iLaunchConfigurationTabArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            tab.setLaunchConfigurationDialog(dialog);
            tab.setDefaults(wc);
            ++n2;
        }
        ProfileLaunchShortcut shortcut = ProviderFramework.getLaunchShortcutProviderFromId(providerId);
        shortcut.setDefaultProfileLaunchShortcutAttributes(wc);
        wc.setAttribute("provider", providerId);
        wc.setAttribute("toolname", providerToolName);
        String curConfigName = wc.getName();
        Pattern configNamePattern = Pattern.compile(".+\\s\\[.+\\](\\s\\(\\d+\\))?$");
        Matcher match = configNamePattern.matcher(curConfigName);
        if (!match.find()) {
            wc.rename(dialog.generateName(curConfigName));
        }
    }

    private void setProfilingType(String profilingType) {
        this.type = profilingType;
    }

    private void setLaunchConfigID(String configId) {
        this.launchConfigId = configId;
    }

    private String getLaunchConfigID() {
        return this.launchConfigId;
    }

    public String getProfilingType() {
        return this.type;
    }

    public static String generateProviderConfigurationName(String configName, String toolName) {
        return String.valueOf(configName) + " " + "[" + toolName + "]";
    }
}

