/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.perf.model;

public class PMStatEntry {
    private float samples;
    private String event;
    private float metrics;
    private String units;
    private float deviation;
    private float scaling;
    public static final String DECIMAL = "\\d+[\\.\\,\\d]*";
    public static final String PERCENTAGE = "(\\d+(\\.\\d+)?)\\%";
    public static final String SAMPLES = "(\\d+[\\.\\,\\d]*)";
    public static final String EVENT = "(\\w+(\\-\\w+)*(:\\w+)?(\\s\\(\\w+\\))?)";
    public static final String METRICS = "(\\d+[\\.\\,\\d]*)";
    public static final String UNITS = "([a-zA-Z\\/\\s\\%]*)";
    public static final String DELTA = "(\\(\\s\\+\\-\\s*(\\d+(\\.\\d+)?)\\%\\s\\))";
    public static final String SCALE = "(\\[\\s*(\\d+(\\.\\d+)?)\\%\\])";
    public static final String TIME_UNIT = "(seconds\\stime\\selapsed)";
    public static final String TIME = "seconds time elapsed";

    public PMStatEntry(float samples, String event, float metrics, String units, float deviation, float scaling) {
        this.samples = samples;
        this.event = event;
        this.metrics = metrics;
        this.units = units;
        this.deviation = deviation;
        this.scaling = scaling;
    }

    public float getSamples() {
        return this.samples;
    }

    public String getEvent() {
        return this.event == null ? "" : this.event;
    }

    public float getMetrics() {
        return this.metrics;
    }

    public String getUnits() {
        return this.units == null ? "" : this.units.trim();
    }

    public float getDeviation() {
        return this.deviation;
    }

    public float getScaling() {
        return this.scaling;
    }

    public String getFormattedMetrics() {
        return String.format("%.3f", Float.valueOf(this.metrics));
    }

    public String getFormattedDeviation() {
        return String.format("%.2f%%", Float.valueOf(this.deviation));
    }

    public boolean equals(Object entry) {
        PMStatEntry statEntry = (PMStatEntry)entry;
        if (statEntry == null || this.samples != statEntry.getSamples() || this.metrics != statEntry.getMetrics() || this.deviation != statEntry.getDeviation() || this.scaling != statEntry.getScaling()) {
            return false;
        }
        return this.getEvent().equals(statEntry.getEvent()) && this.getUnits().equals(statEntry.getUnits());
    }

    public boolean equalEvents(PMStatEntry entry) {
        String event = entry.getEvent();
        if (this.event != null && event != null) {
            return this.event.equals(event);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.deviation);
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        result = 31 * result + Float.floatToIntBits(this.metrics);
        result = 31 * result + Float.floatToIntBits(this.samples);
        result = 31 * result + Float.floatToIntBits(this.scaling);
        result = 31 * result + (this.units == null ? 0 : this.units.hashCode());
        return result;
    }

    public PMStatEntry compare(PMStatEntry entry) {
        float occurrenceDiff = entry.getSamples() - this.samples;
        float metricsDiff = entry.getMetrics() - this.metrics;
        float deviationDiff = entry.getDeviation() + this.deviation;
        float scalingDiff = entry.getScaling() + this.scaling;
        return new PMStatEntry(occurrenceDiff, this.event, metricsDiff, this.units, deviationDiff, scalingDiff);
    }

    public String[] toStringArray() {
        return new String[]{String.valueOf(this.samples), this.getEvent(), this.getFormattedMetrics(), this.getUnits(), this.getFormattedDeviation()};
    }

    public static String getString(Type type) {
        String stringRes = "";
        switch (type) {
            case ENTRY_PATTERN: {
                stringRes = "^(\\d+[\\.\\,\\d]*)";
                stringRes = String.valueOf(stringRes) + "\\s*(\\w+(\\-\\w+)*(:\\w+)?(\\s\\(\\w+\\))?)";
                stringRes = String.valueOf(stringRes) + "\\s*(\\#\\s+(\\d+[\\.\\,\\d]*)([a-zA-Z\\/\\s\\%]*))?";
                stringRes = String.valueOf(stringRes) + "(\\(\\s\\+\\-\\s*(\\d+(\\.\\d+)?)\\%\\s\\))?";
                stringRes = String.valueOf(stringRes) + "(\\s(\\[\\s*(\\d+(\\.\\d+)?)\\%\\]))?$";
                return stringRes;
            }
            case TIME_PATTERN: {
                stringRes = String.valueOf(stringRes) + "^(\\d+[\\.\\,\\d]*)";
                stringRes = String.valueOf(stringRes) + "\\s(seconds\\stime\\selapsed)";
                stringRes = String.valueOf(stringRes) + "\\s+(\\(\\s\\+\\-\\s*(\\d+(\\.\\d+)?)\\%\\s\\))";
                return stringRes;
            }
            case ENTRY_FORMAT: {
                stringRes = String.valueOf(stringRes) + "   %%1$%1$1ds ";
                stringRes = String.valueOf(stringRes) + "%%2$-%2$1ds   #  ";
                stringRes = String.valueOf(stringRes) + "%%3$%3$1ds ";
                stringRes = String.valueOf(stringRes) + "%%4$-%4$1ds  ";
                stringRes = String.valueOf(stringRes) + "( +- %%5$%5$1ds )\n";
                return stringRes;
            }
        }
        return stringRes;
    }

    public static enum Type {
        ENTRY_PATTERN,
        TIME_PATTERN,
        ENTRY_FORMAT,
        PERCENT_FORMAT,
        METRIC_FORMAT;

    }
}

