/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.jdt.docker.launcher;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerImage;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.jdt.docker.launcher.ImageQuery;
import org.eclipse.linuxtools.jdt.docker.launcher.UnixFile;

public class ContainerVMInstall
extends AbstractVMInstall {
    private ILaunchConfiguration config;
    private String name;
    private File installLocation;
    private IDockerImage image;
    private int port;
    private String javaVersion;

    public ContainerVMInstall(ILaunchConfiguration cfg, IDockerImage img, int port) {
        super((IVMInstallType)new StandardVMType(), img.id());
        this.config = cfg;
        this.image = img;
        this.port = port;
    }

    public IVMRunner getVMRunner(String mode) {
        return null;
    }

    public String getId() {
        return this.image.id();
    }

    public String getName() {
        if (this.name == null) {
            DockerConnection conn = this.getConnection();
            ImageQuery q = new ImageQuery(conn, this.image.id());
            this.name = q.getDefaultJVMName();
            q.destroy();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getInstallLocation() {
        if (this.installLocation == null) {
            DockerConnection conn = this.getConnection();
            ImageQuery q = new ImageQuery(conn, this.image.id());
            this.installLocation = q.getDefaultJVMInstallLocation();
            q.destroy();
        }
        return this.installLocation;
    }

    public void setInstallLocation(File installLocation) {
        this.installLocation = installLocation;
    }

    public IVMInstallType getVMInstallType() {
        return null;
    }

    public LibraryLocation[] getLibraryLocations() {
        return null;
    }

    public void setLibraryLocations(LibraryLocation[] locations) {
    }

    public void setJavadocLocation(URL url) {
    }

    public URL getJavadocLocation() {
        return null;
    }

    public String[] getVMArguments() {
        return null;
    }

    public void setVMArguments(String[] vmArgs) {
    }

    public File getJavaExecutable() {
        File installLocation = this.getInstallLocation();
        if (installLocation != null) {
            return this.findJavaExecutable(installLocation);
        }
        return null;
    }

    public int getPort() {
        return this.port;
    }

    public File findJavaExecutable(File vmInstallLocation) {
        String JRE = "jre";
        String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
        String[] fgCandidateJavaLocations = new String[]{"bin/", "jre/bin/"};
        DockerConnection conn = this.getConnection();
        ImageQuery q = new ImageQuery(conn, this.image.id());
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                UnixFile javaFile = new UnixFile(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (q.isFile(javaFile)) {
                    q.destroy();
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        q.destroy();
        return null;
    }

    public DockerConnection getConnection() {
        try {
            String connectionURI = this.config.getAttribute("org.eclipse.linuxtools.jdt.docker.launcher.connection.uri", null);
            return (DockerConnection)DockerConnectionManager.getInstance().getConnectionByUri(connectionURI);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public String getVMArgs() {
        return null;
    }

    public void setVMArgs(String vmArgs) {
    }

    public String getJavaVersion() {
        if (this.javaVersion == null) {
            DockerConnection conn = this.getConnection();
            ImageQuery q = new ImageQuery(conn, this.image.id());
            this.javaVersion = String.valueOf(q.getJavaVersion());
            q.destroy();
        }
        return this.javaVersion;
    }
}

