(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "vscode-languageserver-types", "dockerfile-ast", "./dockerDefinition", "./docker"], factory);
    }
})(function (require, exports) {
    /* --------------------------------------------------------------------------------------------
     * Copyright (c) Remy Suen. All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     * ------------------------------------------------------------------------------------------ */
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    var vscode_languageserver_types_1 = require("vscode-languageserver-types");
    var dockerfile_ast_1 = require("dockerfile-ast");
    var dockerDefinition_1 = require("./dockerDefinition");
    var docker_1 = require("./docker");
    var DockerHighlight = /** @class */ (function () {
        function DockerHighlight() {
        }
        DockerHighlight.prototype.computeHighlightRanges = function (content, position) {
            var dockerfile = dockerfile_ast_1.DockerfileParser.parse(content);
            var provider = new dockerDefinition_1.DockerDefinition();
            var definitionRange = provider.computeDefinitionRange(content, position);
            var image = definitionRange === null ? dockerfile.getContainingImage(position) : dockerfile.getContainingImage(definitionRange.start);
            var highlights = [];
            if (definitionRange === null) {
                for (var _i = 0, _a = dockerfile.getCOPYs(); _i < _a.length; _i++) {
                    var instruction = _a[_i];
                    var flag = instruction.getFromFlag();
                    if (flag) {
                        var range = flag.getValueRange();
                        if (range && range.start.line === position.line && range.start.character <= position.character && position.character <= range.end.character) {
                            var stage = flag.getValue();
                            for (var _b = 0, _c = dockerfile.getCOPYs(); _b < _c.length; _b++) {
                                var other = _c[_b];
                                var otherFlag = other.getFromFlag();
                                if (otherFlag && otherFlag.getValue().toLowerCase() === stage.toLowerCase()) {
                                    highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(otherFlag.getValueRange(), vscode_languageserver_types_1.DocumentHighlightKind.Read));
                                }
                            }
                            return highlights;
                        }
                    }
                }
                for (var _d = 0, _e = dockerfile.getFROMs(); _d < _e.length; _d++) {
                    var from = _e[_d];
                    for (var _f = 0, _g = from.getVariables(); _f < _g.length; _f++) {
                        var variable = _g[_f];
                        if (docker_1.Util.isInsideRange(position, variable.getNameRange())) {
                            var name = variable.getName();
                            for (var _h = 0, _j = dockerfile.getFROMs(); _h < _j.length; _h++) {
                                var loopFrom = _j[_h];
                                for (var _k = 0, _l = loopFrom.getVariables(); _k < _l.length; _k++) {
                                    var fromVariable = _l[_k];
                                    if (fromVariable.getName() === name) {
                                        highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(fromVariable.getNameRange(), vscode_languageserver_types_1.DocumentHighlightKind.Read));
                                    }
                                }
                            }
                            return highlights;
                        }
                    }
                }
                for (var _m = 0, _o = image.getInstructions(); _m < _o.length; _m++) {
                    var instruction = _o[_m];
                    for (var _p = 0, _q = instruction.getVariables(); _p < _q.length; _p++) {
                        var variable = _q[_p];
                        if (docker_1.Util.isInsideRange(position, variable.getNameRange())) {
                            var name = variable.getName();
                            for (var _r = 0, _s = image.getInstructions(); _r < _s.length; _r++) {
                                var instruction_1 = _s[_r];
                                if (!(instruction_1 instanceof dockerfile_ast_1.From)) {
                                    for (var _t = 0, _u = instruction_1.getVariables(); _t < _u.length; _t++) {
                                        var variable_1 = _u[_t];
                                        if (variable_1.getName() === name) {
                                            highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(variable_1.getNameRange(), vscode_languageserver_types_1.DocumentHighlightKind.Read));
                                        }
                                    }
                                }
                            }
                            return highlights;
                        }
                    }
                }
            }
            else {
                var document = vscode_languageserver_types_1.TextDocument.create("", "", 0, content);
                var definition = document.getText().substring(document.offsetAt(definitionRange.start), document.offsetAt(definitionRange.end));
                var isBuildStage = false;
                for (var _v = 0, _w = dockerfile.getFROMs(); _v < _w.length; _v++) {
                    var from = _w[_v];
                    var stage = from.getBuildStage();
                    if (stage && definition.toLowerCase() === stage.toLowerCase()) {
                        highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(from.getBuildStageRange(), vscode_languageserver_types_1.DocumentHighlightKind.Write));
                        isBuildStage = true;
                    }
                }
                if (isBuildStage) {
                    for (var _x = 0, _y = dockerfile.getCOPYs(); _x < _y.length; _x++) {
                        var instruction = _y[_x];
                        var flag = instruction.getFromFlag();
                        if (flag) {
                            if (flag.getValue().toLowerCase() === definition.toLowerCase()) {
                                highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(flag.getValueRange(), vscode_languageserver_types_1.DocumentHighlightKind.Read));
                            }
                        }
                    }
                    return highlights;
                }
                for (var _z = 0, _0 = image.getARGs(); _z < _0.length; _z++) {
                    var arg = _0[_z];
                    var property = arg.getProperty();
                    // property may be null if it's an ARG with no arguments
                    if (property && property.getName() === definition) {
                        highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(property.getNameRange(), vscode_languageserver_types_1.DocumentHighlightKind.Write));
                    }
                }
                for (var _1 = 0, _2 = image.getENVs(); _1 < _2.length; _1++) {
                    var env = _2[_1];
                    for (var _3 = 0, _4 = env.getProperties(); _3 < _4.length; _3++) {
                        var property = _4[_3];
                        if (property.getName() === definition) {
                            highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(property.getNameRange(), vscode_languageserver_types_1.DocumentHighlightKind.Write));
                        }
                    }
                }
                for (var _5 = 0, _6 = image.getInstructions(); _5 < _6.length; _5++) {
                    var instruction = _6[_5];
                    // only highlight variables in non-FROM instructions
                    if (!(instruction instanceof dockerfile_ast_1.From)) {
                        for (var _7 = 0, _8 = instruction.getVariables(); _7 < _8.length; _7++) {
                            var variable = _8[_7];
                            if (variable.getName() === definition) {
                                highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(variable.getNameRange(), vscode_languageserver_types_1.DocumentHighlightKind.Read));
                            }
                        }
                    }
                }
                for (var _9 = 0, _10 = dockerfile.getInitialARGs(); _9 < _10.length; _9++) {
                    var arg = _10[_9];
                    var property = arg.getProperty();
                    if (property && docker_1.Util.rangeEquals(property.getNameRange(), definitionRange)) {
                        for (var _11 = 0, _12 = dockerfile.getFROMs(); _11 < _12.length; _11++) {
                            var from = _12[_11];
                            for (var _13 = 0, _14 = from.getVariables(); _13 < _14.length; _13++) {
                                var variable = _14[_13];
                                if (variable.getName() === definition) {
                                    highlights.push(vscode_languageserver_types_1.DocumentHighlight.create(variable.getNameRange(), vscode_languageserver_types_1.DocumentHighlightKind.Read));
                                }
                            }
                        }
                    }
                }
            }
            return highlights;
        };
        return DockerHighlight;
    }());
    exports.DockerHighlight = DockerHighlight;
});
