/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.linuxtools.changelog.core.IParserChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.Messages;

public final class ChangeLogExtensionManager {
    private static final ChangeLogExtensionManager EXM = new ChangeLogExtensionManager();
    private IConfigurationElement cachedPrefFormatter = null;
    private IConfigurationElement[] cachedInFileFormateters = null;
    private IExtensionPoint parserExtensions = null;
    private IExtensionPoint formatterExtensions = null;
    private IParserChangeLogContrib parserContributor = null;
    private IConfigurationElement formatterConfigElementToUse = null;

    private ChangeLogExtensionManager() {
        this.getParserContributions();
        this.getFormatterContributions();
    }

    public static ChangeLogExtensionManager getExtensionManager() {
        return EXM;
    }

    private void getFormatterContributions() {
        this.formatterExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "formatterContribution");
    }

    private void getParserContributions() {
        this.parserExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "parserContribution");
    }

    public IParserChangeLogContrib getParserContributor(String editorName) {
        if (this.parserExtensions != null) {
            IConfigurationElement[] elements = this.parserExtensions.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("parser") && elements[i].getAttribute("editor").equals(editorName)) {
                    try {
                        IConfigurationElement bob = elements[i];
                        this.parserContributor = (IParserChangeLogContrib)bob.createExecutableExtension("class");
                        return this.parserContributor;
                    }
                    catch (CoreException e) {
                        ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public IConfigurationElement getFormatterConfigElement() {
        return this.formatterConfigElementToUse;
    }

    public IFormatterChangeLogContrib getFormatterContributor(String entryFilePath, String formatterName) {
        int lastDir = entryFilePath.lastIndexOf(47);
        String fileName = lastDir >= 0 && lastDir + 1 <= entryFilePath.length() ? entryFilePath.substring(lastDir + 1, entryFilePath.length()) : entryFilePath;
        this.formatterConfigElementToUse = null;
        if (this.formatterExtensions != null) {
            IConfigurationElement[] elements = this.formatterExtensions.getConfigurationElements();
            if (this.cachedInFileFormateters == null) {
                LinkedList<IConfigurationElement> inFileFormatters = new LinkedList<IConfigurationElement>();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement formatterConfigElement = elements[i];
                    if (formatterConfigElement.getName().equals("formatter") && formatterConfigElement.getAttribute("inFile").equalsIgnoreCase("true")) {
                        inFileFormatters.add(elements[i]);
                    }
                    ++i;
                }
                this.cachedInFileFormateters = inFileFormatters.toArray(new IConfigurationElement[0]);
            }
            int i = 0;
            while (i < this.cachedInFileFormateters.length) {
                IConfigurationElement formatterConfigElement = this.cachedInFileFormateters[i];
                IConfigurationElement[] patternElementTmp = formatterConfigElement.getChildren();
                if (patternElementTmp != null) {
                    IConfigurationElement patternElement = patternElementTmp[0];
                    if (patternElement.getAttribute("pattern") == null) {
                        ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, Messages.getString("ChangeLog.ErrNonPattern"), (Throwable)new Exception(Messages.getString("ChangeLog.ErrNonPattern"))));
                    } else {
                        String filePattern = patternElement.getAttribute("pattern");
                        try {
                            Pattern pattern = Pattern.compile(filePattern);
                            Matcher fileMatcher = pattern.matcher(fileName);
                            if (fileMatcher.matches()) {
                                this.formatterConfigElementToUse = formatterConfigElement;
                                break;
                            }
                        }
                        catch (PatternSyntaxException e) {
                            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
                        }
                    }
                }
                ++i;
            }
            if (this.formatterConfigElementToUse == null) {
                if (this.cachedPrefFormatter == null || !this.cachedPrefFormatter.getAttribute("name").equals(formatterName)) {
                    i = 0;
                    while (i < elements.length) {
                        IConfigurationElement formatterConfigElement = elements[i];
                        if (formatterConfigElement.getName().equals("formatter") && formatterConfigElement.getAttribute("inFile").equalsIgnoreCase("false")) {
                            if (!formatterConfigElement.getAttribute("name").equals(formatterName)) break;
                            this.cachedPrefFormatter = formatterConfigElement;
                            break;
                        }
                        ++i;
                    }
                }
                this.formatterConfigElementToUse = this.cachedPrefFormatter;
                if (this.formatterConfigElementToUse == null) {
                    ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, Messages.getString("ChangeLog.ErrRetrieveFormatter"), (Throwable)new Exception(Messages.getString("ChangeLog.ErrRetrieveFormatter"))));
                    return null;
                }
            }
        }
        try {
            return (IFormatterChangeLogContrib)this.formatterConfigElementToUse.createExecutableExtension("class");
        }
        catch (CoreException e) {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
            e.printStackTrace();
            return null;
        }
    }
}

