/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.exportwizard;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.libra.warproducts.ui.exportwizard.ExportPage;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportTab;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DestinationGroup
extends AbstractExportTab {
    protected static final String EXPORT_DIRECTORY = "exportDirectory";
    protected static final String DESTINATION = "destination";
    protected static final String ZIP_FILENAME = "zipFileName";
    protected Combo archiveCombo;
    protected Button browseFile;
    private ExportPage page;

    public DestinationGroup(ExportPage page) {
        super((AbstractExportWizardPage)page);
        this.page = page;
    }

    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        layout.marginHeight = 0;
        container.setLayoutData((Object)new GridData(768));
        Label description = new Label(container, 0);
        description.setText(Messages.DestinationGroupFile);
        this.archiveCombo = new Combo(container, 2048);
        this.archiveCombo.setLayoutData((Object)new GridData(768));
        this.browseFile = new Button(container, 8);
        this.browseFile.setText(Messages.DestinationGroupBrowe);
        this.browseFile.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint((Button)this.browseFile);
        return container;
    }

    protected void initialize(IDialogSettings settings) {
        this.initialize(settings, null);
    }

    protected void initialize(IDialogSettings settings, IFile file) {
        this.initializeCombo(settings, ZIP_FILENAME, this.archiveCombo);
        this.updateDestination(file);
        this.hookListeners();
    }

    protected void initializeCombo(IDialogSettings settings, String key, Combo combo) {
        super.initializeCombo(settings, key, combo);
        if (!this.isValidLocation(combo.getText().trim())) {
            combo.setText("");
        }
    }

    protected void updateDestination(IFile file) {
        try {
            if (file != null) {
                Combo combo = this.archiveCombo;
                QualifiedName location = IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_LOCATION;
                String destination = file.getPersistentProperty(location);
                if (destination != null) {
                    if (combo.indexOf(destination) == -1) {
                        combo.add(destination, 0);
                    }
                    combo.setText(destination);
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected void hookListeners() {
        this.browseFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] filters = new String[]{"*.war"};
                DestinationGroup.this.chooseFile(DestinationGroup.this.archiveCombo, filters);
            }
        });
        this.archiveCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DestinationGroup.this.page.pageChanged();
            }
        });
    }

    protected void saveSettings(IDialogSettings settings) {
        this.saveCombo(settings, ZIP_FILENAME, this.archiveCombo);
        IFile file = this.page.getProductFile();
        try {
            if (file != null && file.exists()) {
                QualifiedName location = IPDEUIConstants.DEFAULT_PRODUCT_EXPORT_LOCATION;
                file.setPersistentProperty(location, this.archiveCombo.getText().trim());
            }
        }
        catch (CoreException coreException) {}
    }

    protected String validate() {
        String result = null;
        if (this.archiveCombo.getText().trim().length() == 0) {
            result = Messages.DestinationGroupWarning;
        } else if (!this.isValidLocation(this.archiveCombo.getText().trim())) {
            result = Messages.DestinationGroupWarningDirectory;
        }
        return result;
    }

    protected String getFileName() {
        String result = null;
        String path = this.archiveCombo.getText();
        if (path != null && path.length() > 0) {
            String fileName = new Path(path).lastSegment();
            if (!fileName.endsWith(".war")) {
                fileName = String.valueOf(fileName) + ".war";
            }
            result = fileName;
        }
        return result;
    }

    protected String getDestination() {
        String result = "";
        String path = this.archiveCombo.getText();
        if (path.length() > 0) {
            path = new Path(path).removeLastSegments(1).toOSString();
            result = new File(path).getAbsolutePath();
        }
        return result;
    }
}

