/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.framework.ServiceStateMBean;

public class ServicesData {
    private Map<Long, ServiceInfo> map = new HashMap<Long, ServiceInfo>();

    public ServicesData(ServiceStateMBean serviceStateMBean) throws IOException {
        TabularData data = serviceStateMBean.listServices();
        Set<?> keys = data.keySet();
        for (List key : keys) {
            CompositeData serviceInfo = data.get(key.toArray());
            Long serviceId = (Long)serviceInfo.get("Identifier");
            Long bundleId = (Long)serviceInfo.get("BundleIdentifier");
            String[] objectClass = (String[])serviceInfo.get("objectClass");
            Long[] usingBundles = (Long[])serviceInfo.get("UsingBundles");
            this.map.put(serviceId, new ServiceInfo(serviceId, bundleId, objectClass, usingBundles));
        }
    }

    public ServiceInfo getService(Long serviceId) {
        return this.map.get(serviceId);
    }

    public class ServiceInfo {
        private Long serviceId;
        private Long bundleId;
        private String[] objectClass;
        private Long[] usingBundles;

        ServiceInfo(Long serviceId, Long bundleId, String[] objectClass, Long[] usingBundles) {
            this.serviceId = serviceId;
            this.bundleId = bundleId;
            this.objectClass = objectClass;
            this.usingBundles = usingBundles;
        }

        public Long getServiceId() {
            return this.serviceId;
        }

        public Long getBundleId() {
            return this.bundleId;
        }

        public String[] getObjectClass() {
            return this.objectClass;
        }

        public Long[] getUsingBundles() {
            return this.usingBundles;
        }
    }
}

