/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.libra.facet.OSGiBundleFacetUninstallConfig;
import org.eclipse.libra.facet.OSGiBundleFacetUninstallStrategy;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class OSGiBundleFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object configObject, IProgressMonitor monitor) throws CoreException {
        OSGiBundleFacetUninstallConfig config = (OSGiBundleFacetUninstallConfig)((Object)configObject);
        OSGiBundleFacetUninstallStrategy strategy = config == null ? OSGiBundleFacetUninstallStrategy.defaultStrategy() : config.getStrategy();
        this.doExecute(project, strategy, monitor);
    }

    public void doExecute(IProject project, OSGiBundleFacetUninstallStrategy strategy, IProgressMonitor monitor) throws CoreException {
        if (strategy == OSGiBundleFacetUninstallStrategy.FACET_AND_PLUGIN_NATURE_BUT_NOT_MANIFEST || strategy == OSGiBundleFacetUninstallStrategy.FACET_AND_PLUGIN_NATURE_AND_MANIFEST) {
            this.removePluginNature(project, monitor);
            this.removeRequiredBundlesClasspathContainer(project, monitor);
            this.deleteBuildProperties(project, monitor);
        }
        if (strategy == OSGiBundleFacetUninstallStrategy.FACET_AND_PLUGIN_NATURE_AND_MANIFEST) {
            this.cleanUpManifest(project, monitor);
        }
    }

    private void removePluginNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        if (description.hasNature("org.eclipse.pde.PluginNature")) {
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (natures[i].equals("org.eclipse.pde.PluginNature")) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    this.removeFromBuildSpec(description, "org.eclipse.pde.ManifestBuilder");
                    this.removeFromBuildSpec(description, "org.eclipse.pde.SchemaBuilder");
                    project.setDescription(description, 2, monitor);
                    return;
                }
                ++i;
            }
        }
    }

    private void removeFromBuildSpec(IProjectDescription description, String builderId) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderId)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                return;
            }
            ++i;
        }
    }

    private void removeRequiredBundlesClasspathContainer(IProject project, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject;
        IClasspathEntry[] entries;
        if (OSGiBundleFacetUtils.isJavaProject(project) && OSGiBundleFacetUtils.hasRequiredPlugins(entries = (javaProject = JavaCore.create((IProject)project)).getRawClasspath())) {
            int i = 0;
            while (i < entries.length) {
                if (OSGiBundleFacetUtils.isRequiredPlugins(entries[i])) {
                    IClasspathEntry[] newEntries = new IClasspathEntry[entries.length - 1];
                    System.arraycopy(entries, 0, newEntries, 0, i);
                    System.arraycopy(entries, i + 1, newEntries, i, entries.length - i - 1);
                    javaProject.setRawClasspath(newEntries, monitor);
                    return;
                }
                ++i;
            }
        }
    }

    private void deleteBuildProperties(IProject project, IProgressMonitor monitor) throws CoreException {
        IResource buildPropertiesFile = this.findResource(project, "build.properties");
        buildPropertiesFile.delete(2, monitor);
    }

    private void cleanUpManifest(IProject project, IProgressMonitor monitor) throws CoreException {
        IResource manifestFile = this.findResource(project, "META-INF/MANIFEST.MF");
        manifestFile.delete(2, monitor);
        IContainer metaInfFolder = manifestFile.getParent();
        if (metaInfFolder.members().length == 0) {
            metaInfFolder.delete(2, monitor);
        }
    }

    private IResource findResource(IProject project, String memberURI) throws CoreException {
        IBundleProjectDescription bundleProjectDescription = OSGiBundleFacetUtils.getBundleProjectDescription(project);
        IPath bundleRoot = bundleProjectDescription.getBundleRoot();
        IPath memberPath = bundleRoot;
        if (memberPath == null) {
            memberPath = new Path("");
        }
        memberPath = memberPath.append(memberURI);
        return project.findMember(memberPath);
    }
}

