/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.toolkit.base.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.client.launch.AUTConfiguration;
import org.eclipse.jubula.tools.AUTIdentifier;
import org.eclipse.jubula.tools.internal.registration.AutIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAUTConfiguration
implements AUTConfiguration {
    private static Logger log = LoggerFactory.getLogger(AbstractAUTConfiguration.class);
    @Nullable
    private String m_name;
    @NonNull
    private AUTIdentifier m_autID;
    @NonNull
    private Map<String, String> m_launchInformation = new HashMap<String, String>();

    public AbstractAUTConfiguration(@Nullable String name, @NonNull String autID) {
        this.m_name = name;
        Validate.notEmpty((String)autID, (String)"The AUT-Identifier must not be empty");
        this.m_autID = new AutIdentifier(autID);
        this.add("AUT_ID", this.getAutID().getID());
    }

    protected void add(String option, String value) {
        if (this.m_launchInformation.containsKey(option)) {
            log.warn("Option has already been configured: " + option);
        }
        this.m_launchInformation.put(option, value);
    }

    @Nullable
    public String getName() {
        return this.m_name;
    }

    @NonNull
    public AUTIdentifier getAutID() {
        return this.m_autID;
    }

    @NonNull
    public Map<String, String> getLaunchInformation() {
        return Collections.unmodifiableMap(this.m_launchInformation);
    }
}

