/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.connection.Connection;
import org.eclipse.jubula.communication.internal.listener.IErrorHandler;
import org.eclipse.jubula.communication.internal.message.CAPTestResponseMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.MessageCap;
import org.eclipse.jubula.communication.internal.message.MessageHeader;
import org.eclipse.jubula.communication.internal.message.PrepareForShutdownMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareForShutdownCommand
implements ICommand {
    public static final String AUT_KEEP_ALIVE_DELAY_VAR = "TEST_AUT_KEEP_ALIVE_DELAY";
    private static Thread shutdownHookThread = null;
    private static final Logger LOG = LoggerFactory.getLogger(PrepareForShutdownCommand.class);
    private PrepareForShutdownMessage m_message;

    public Message execute() {
        PrepareForShutdownMessage message = this.m_message;
        boolean isForce = message.isForce();
        if (isForce) {
            Communicator agentCommunicator = AUTServer.getInstance().getServerCommunicator();
            if (agentCommunicator != null) {
                agentCommunicator.clearListeners();
            }
            Connection autAgentConnection = agentCommunicator.getConnection();
            if (shutdownHookThread != null) {
                Runtime.getRuntime().removeShutdownHook(shutdownHookThread);
            }
            if (autAgentConnection != null) {
                autAgentConnection.addErrorHandler(new IErrorHandler(){

                    public void shutDown() {
                        this.terminate();
                    }

                    public void sendFailed(MessageHeader header, String msg) {
                        this.terminate();
                    }

                    private void terminate() {
                        try {
                            AUTServer.getInstance().shutdown();
                        }
                        finally {
                            System.exit(0);
                        }
                    }
                });
            }
        } else if (shutdownHookThread == null) {
            int addDelay = message.getAdditionalDelay();
            shutdownHookThread = new Thread(new AUTProperTerminationShutdownHook(addDelay));
            Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        }
        return null;
    }

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (PrepareForShutdownMessage)message;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + "timeout() called");
    }

    private static class AUTProperTerminationShutdownHook
    implements Runnable {
        private int m_addDelay;

        public AUTProperTerminationShutdownHook(int addDelay) {
            this.setAddDelay(addDelay);
        }

        public void run() {
            Communicator agentCommunicator;
            AUTServer autRC = AUTServer.getInstance();
            if (!autRC.isRcpAccessible()) {
                this.sendFakeCAPTestReponseMessage(autRC);
            }
            if ((agentCommunicator = autRC.getServerCommunicator()) != null) {
                agentCommunicator.clearListeners();
            }
            long timeToWait = 5000L;
            try {
                String value = EnvironmentUtils.getProcessOrSystemProperty((String)PrepareForShutdownCommand.AUT_KEEP_ALIVE_DELAY_VAR);
                timeToWait = Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {}
            TimeUtil.delay((long)(timeToWait + (long)this.getAddDelay()));
        }

        private void sendFakeCAPTestReponseMessage(AUTServer autRC) {
            Communicator iteCom = autRC.getCommunicator();
            CAPTestResponseMessage fakeMessage = new CAPTestResponseMessage();
            MessageCap fakeMessageCap = new MessageCap();
            fakeMessageCap.setCi((IComponentIdentifier)new ComponentIdentifier());
            fakeMessage.setMessageCap(fakeMessageCap);
            try {
                iteCom.send((Message)fakeMessage);
            }
            catch (CommunicationException e) {
                LOG.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        public int getAddDelay() {
            return this.m_addDelay;
        }

        public void setAddDelay(int addDelay) {
            this.m_addDelay = addDelay;
        }
    }
}

