/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.rcp.dialogs.ClassPathDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.BaseMultiBrowserComposite;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Composite;

public class FileDirectoryBrowser
extends BaseMultiBrowserComposite {
    private Set<IFileDirectorySelectionListener> m_listeners = new HashSet<IFileDirectorySelectionListener>();
    private String[] m_filterExtensions;
    private String m_selectDialogTitle;
    private boolean m_fileSelectionAllowed;

    public FileDirectoryBrowser(Composite parent, String selectDialogTitle, String attrId, String configurationValue, String[] extensionFilters, boolean fileSelectionAllowed) {
        super(parent, attrId, configurationValue);
        this.m_filterExtensions = extensionFilters;
        this.m_selectDialogTitle = selectDialogTitle;
        this.m_fileSelectionAllowed = fileSelectionAllowed;
    }

    @Override
    void handleSelection(boolean isEditButtonPressed) {
        int maxLength = 4000 - this.getItemsLength();
        if (maxLength < 1) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_TOO_LONG_CLASSPATH, (Object[])new Object[]{4000}, null);
            return;
        }
        String oldItemPath = "";
        if (isEditButtonPressed) {
            oldItemPath = this.getItemList().getSelection()[0];
        }
        ClassPathDialog dialog = new ClassPathDialog(this.getShell(), this.m_selectDialogTitle, oldItemPath, Messages.AUTConfigComponentMessage, Messages.AUTConfigComponentLabel, Messages.AUTConfigComponentWrongInputMessage, "", null, Messages.AUTConfigComponentShellText, false, maxLength, this.getIsBrowseable(), this.m_filterExtensions, this.m_fileSelectionAllowed);
        dialog.setStyle(32);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String[] elements = dialog.getName().split(System.getProperty("path.separator"));
            int i = 0;
            while (i < elements.length) {
                String element = elements[i];
                if (element != null) {
                    if (isEditButtonPressed) {
                        this.getItemList().remove(oldItemPath);
                        this.getItemList().add(element);
                    } else {
                        this.getItemList().add(element);
                    }
                }
                ++i;
            }
            this.updateStoredValues();
        }
    }

    @Override
    void updateStoredValues() {
        this.fireListChanged(String.valueOf(this.getItemList().getData("MONITORING_KEY")), this.getItemPathes());
    }

    private void fireListChanged(String key, String value) {
        for (IFileDirectorySelectionListener listener : this.m_listeners) {
            listener.selectedFileDirectoriesChanged(key, value);
        }
    }

    private boolean getIsBrowseable() {
        Iterator<IFileDirectorySelectionListener> iterator = this.m_listeners.iterator();
        if (iterator.hasNext()) {
            IFileDirectorySelectionListener listener = iterator.next();
            return listener.isBrowseable();
        }
        return false;
    }

    public void addListModifiedListener(IFileDirectorySelectionListener listener) {
        this.m_listeners.add(listener);
    }

    public static interface IFileDirectorySelectionListener {
        public void selectedFileDirectoriesChanged(String var1, String var2);

        public boolean isBrowseable();
    }
}

