/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.problems.IProblem;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;

public class TooltipLabelProvider
extends GeneralLabelProvider {
    private static final String MULTI_LINE_TOOLTIP_PREFIX = "- ";

    @Override
    public String getToolTipText(Object element) {
        IProblem prob;
        if (element instanceof INodePO) {
            INodePO node = (INodePO)element;
            if (ProblemFactory.hasProblem((INodePO)node)) {
                Set worstProblems = ProblemFactory.getWorstProblems((Set)node.getProblems());
                StringBuilder sb = new StringBuilder();
                String prefix = "";
                int size = worstProblems.size();
                if (size > 1) {
                    prefix = MULTI_LINE_TOOLTIP_PREFIX;
                }
                int count = 0;
                for (IProblem problem : worstProblems) {
                    sb.append(prefix);
                    sb.append(problem.getTooltipMessage());
                    if (++count >= size) continue;
                    sb.append("\n");
                }
                return sb.toString();
            }
        } else if (element instanceof IComponentNamePO && (prob = ((IComponentNamePO)element).getTypeProblem()) != null) {
            return prob.getTooltipMessage();
        }
        return super.getToolTipText(element);
    }
}

