/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.delete;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.handlers.delete.AbstractDeleteTreeItemHandler;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;

public class DeleteComponentNameInViewHandler
extends AbstractDeleteTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IStructuredSelection structuredSelection = this.getSelection();
        HashSet<IComponentNamePO> toDelete = new HashSet<IComponentNamePO>();
        Object[] objectArray = structuredSelection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IComponentNamePO) {
                toDelete.add((IComponentNamePO)obj);
            }
            ++n2;
        }
        ArrayList<String> itemNames = new ArrayList<String>();
        for (IComponentNamePO compName : toDelete) {
            itemNames.add(compName.getName());
        }
        if (this.confirmDelete(itemNames)) {
            try {
                CompNameManager.getInstance().deleteCompNames(toDelete);
                for (IComponentNamePO compName : toDelete) {
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
                }
            }
            catch (PMException e) {
                PMExceptionHandler.handlePMExceptionForMasterSession(e);
            }
            catch (ProjectDeletedException projectDeletedException) {
                PMExceptionHandler.handleProjectDeletedException();
            }
        }
        return null;
    }
}

