/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.SearchResultPage;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.jubula.client.ui.rcp.utils.SearchPageUtils;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.param.ChangeCtdsColumnUsageWizard;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.param.ExistingAndNewParameterData;
import org.eclipse.jubula.client.ui.rcp.wizards.refactor.param.TestCasesValidator;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;

public class SearchChangeCtdsColumnUsageHandler
extends AbstractSelectionBasedHandler {
    protected Object executeImpl(ExecutionEvent event) {
        SearchResultPage page = SearchPageUtils.getSearchResultPage(event);
        if (page == null) {
            return null;
        }
        if (!Plugin.getDefault().showSaveEditorDialog(this.getActiveShell())) {
            return null;
        }
        List oldSelection = this.getSelection().toList();
        HashSet<ITestCasePO> testCases = new HashSet<ITestCasePO>();
        EntityManager session = GeneralStorage.getInstance().getMasterSession();
        for (BasicSearchResult.SearchResultElement searchResult : oldSelection) {
            INodePO nodePO;
            if (!(searchResult.getData() instanceof Long) || !((nodePO = (INodePO)session.find(NodeMaker.getNodePOClass(), searchResult.getData())) instanceof ITestCasePO)) continue;
            testCases.add((ITestCasePO)nodePO);
        }
        TestCasesValidator validator = new TestCasesValidator(testCases);
        if (!validator.isReferencedDataCubeOk()) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_ALL_TCS_MUST_USE_SAME_CTDS);
            return null;
        }
        if (!validator.areAllTestCasesOk()) {
            if (MessageDialog.openQuestion(null, (String)Messages.ChangeCtdsColumnUsageActionDialog, (String)Messages.ChangeCtdsColumnUsageQuestionDeselect)) {
                SearchPageUtils.selectTestCases(page, oldSelection, validator.getValidTestCases());
            }
            return null;
        }
        ExistingAndNewParameterData paramData = new ExistingAndNewParameterData(validator.getValidTestCases());
        if (paramData.getAllParamDescriptions().length == 0) {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_TCS_HAVE_NO_CHANGEABLE_PARAMETER_NAME);
            return null;
        }
        this.showWizardDialog(paramData);
        return null;
    }

    private void showWizardDialog(ExistingAndNewParameterData paramData) {
        WizardDialog dialog = new WizardDialog(this.getActiveShell(), (IWizard)new ChangeCtdsColumnUsageWizard(paramData));
        dialog.setHelpAvailable(true);
        dialog.open();
    }
}

