/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.progress.ProgressConsoleRegistry;
import org.eclipse.jubula.client.stats.i18n.Messages;
import org.eclipse.osgi.util.NLS;

public class JobExecutionTracker
implements IJobChangeListener {
    private Map<Job, StopWatch> m_tracker = new HashMap<Job, StopWatch>();

    public void aboutToRun(IJobChangeEvent event) {
        StopWatch sw = new StopWatch();
        this.m_tracker.put(event.getJob(), sw);
        sw.start();
    }

    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        StopWatch stopWatch = this.m_tracker.get(job);
        if (stopWatch != null) {
            stopWatch.stop();
            if (!job.isSystem()) {
                this.log(NLS.bind((String)Messages.ConsoleOutput, (Object[])new Object[]{job.getName(), job.getResult(), stopWatch.getTime()}));
            }
            this.m_tracker.remove(job);
        }
    }

    private void log(String string) {
        ProgressConsoleRegistry.INSTANCE.getConsole().writeStatus((IStatus)new Status(1, "org.eclipse.jubula.client.stats", string));
    }

    public void awake(IJobChangeEvent event) {
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }
}

