/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.tagregistry;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.internal.CompositeTagRegistryFactory;
import org.eclipse.jst.jsf.core.internal.ITagRegistryFactoryInfo;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.tagregistry.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaglibContentProvider
implements IStructuredContentProvider,
ITreeContentProvider,
ITagRegistry.ITagRegistryListener {
    private static final Object[] NO_CHILDREN = new Object[0];
    private IProject _curInput;
    private Map<ITagRegistry, TagRegistryInstance> _curTagRegistries = new HashMap<ITagRegistry, TagRegistryInstance>();
    private Viewer _curViewer;
    private final AtomicLong _changeStamp = new AtomicLong(0L);

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IProject) {
            return this._curTagRegistries.values().toArray();
        }
        return NO_CHILDREN;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._changeStamp.incrementAndGet();
        this._curViewer = viewer;
        if (oldInput instanceof IProject) {
            for (TagRegistryInstance tagRegistry : this._curTagRegistries.values()) {
                tagRegistry.getRegistry().removeListener((ITagRegistry.ITagRegistryListener)this);
            }
        }
        if (newInput instanceof IProject) {
            this._curInput = (IProject)newInput;
            Set factories = CompositeTagRegistryFactory.getInstance().getAllTagRegistryFactories();
            this._curTagRegistries.clear();
            for (ITagRegistryFactoryInfo factoryInfo : factories) {
                TagRegistryFactory factory = factoryInfo.getTagRegistryFactory();
                try {
                    ITagRegistry registry = factory.createTagRegistry(this._curInput);
                    if (registry == null) continue;
                    TagRegistryInstance registryInstance = new TagRegistryInstance(factoryInfo, registry);
                    this._curTagRegistries.put(registry, registryInstance);
                    registry.addListener((ITagRegistry.ITagRegistryListener)this);
                    new UpdateNamespacesListJob(this._curInput, this._changeStamp.get(), registryInstance).schedule();
                }
                catch (TagRegistryFactory.TagRegistryFactoryException e) {
                    JSFUiPlugin.log(4, "Problem getting tag registry", e);
                }
            }
        } else {
            this._curInput = null;
            this._curTagRegistries.clear();
        }
    }

    public Object[] getChildren(Object parentElement) {
        Map attributes;
        if (parentElement instanceof IProject) {
            return this._curTagRegistries.values().toArray();
        }
        if (parentElement instanceof TagRegistryInstance) {
            TagRegistryInstance regInstance = (TagRegistryInstance)parentElement;
            if (!regInstance.isUpToDate()) {
                return new Object[]{new TreePlaceholder(Messages.TaglibContentProvider_Calculating, null)};
            }
            return regInstance.getNamespaces().values().toArray();
        }
        if (parentElement instanceof Namespace) {
            final Namespace ns = (Namespace)parentElement;
            if (ns.isInitialized()) {
                return ((Namespace)parentElement).getViewElements().toArray();
            }
            Job updateNamespaceJob = new Job(Messages.TaglibContentProvider_JobDesc){

                protected IStatus run(IProgressMonitor monitor) {
                    ns.getViewElements();
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (ns.isInitialized()) {
                                TaglibContentProvider.this.viewerRefresh(ns);
                            } else {
                                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.TaglibContentProvider_NamespaceErrorTitle, (String)Messages.TaglibContentProvider_NamespaceErrorDescription);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            updateNamespaceJob.schedule();
            return new Object[]{new TreePlaceholder(Messages.TaglibContentProvider_TagCalculatingWaitMessage, null)};
        }
        if (parentElement instanceof ITagElement && (attributes = ((ITagElement)parentElement).getAttributes()) != null) {
            return attributes.values().toArray();
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TagRegistryInstance) {
            return true;
        }
        if (element instanceof Namespace) {
            return ((Namespace)element).hasViewElements();
        }
        return this.getChildren(element).length > 0;
    }

    public void registryChanged(ITagRegistry.TagRegistryChangeEvent changeEvent) {
        TagRegistryInstance registryInstance;
        if (this._curViewer != null && (registryInstance = this._curTagRegistries.get(changeEvent.getSource())) != null) {
            this._curViewer.getControl().getDisplay().asyncExec((Runnable)new RegistryChangeTask(changeEvent.getType(), changeEvent.getAffectedObjects(), this._changeStamp.get(), registryInstance));
        }
    }

    private void viewerRefresh(Object parentElement) {
        if (this._curViewer instanceof StructuredViewer) {
            StructuredViewer viewer = (StructuredViewer)this._curViewer;
            viewer.refresh(parentElement);
        } else {
            this._curViewer.refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RegistryChangeTask
    implements Runnable {
        private final ITagRegistry.TagRegistryChangeEvent.EventType _eventType;
        private final long _timestamp;
        private final List<? extends Namespace> _affectedObjects;
        private final TagRegistryInstance _registryInstance;

        RegistryChangeTask(ITagRegistry.TagRegistryChangeEvent.EventType eventType, List<? extends Namespace> affectedObjects, long timestamp, TagRegistryInstance registryInstance) {
            this._eventType = eventType;
            this._timestamp = timestamp;
            this._affectedObjects = affectedObjects;
            this._registryInstance = registryInstance;
        }

        @Override
        public void run() {
            if (this._timestamp != TaglibContentProvider.this._changeStamp.get()) {
                return;
            }
            switch (this._eventType) {
                case ADDED_NAMESPACE: 
                case CHANGED_NAMESPACE: {
                    for (Namespace namespace : this._affectedObjects) {
                        this._registryInstance.getNamespaces().put(namespace.getNSUri(), namespace);
                    }
                    TaglibContentProvider.this.viewerRefresh(TaglibContentProvider.this._curInput);
                    break;
                }
                case REMOVED_NAMESPACE: {
                    for (Namespace namespace : this._affectedObjects) {
                        this._registryInstance.getNamespaces().remove(namespace.getNSUri());
                    }
                    TaglibContentProvider.this.viewerRefresh(TaglibContentProvider.this._curInput);
                    break;
                }
                case REGISTRY_DISPOSED: {
                    this._registryInstance.getRegistry().removeListener((ITagRegistry.ITagRegistryListener)TaglibContentProvider.this);
                    TaglibContentProvider.this._curTagRegistries.remove(this._registryInstance);
                    TaglibContentProvider.this.viewerRefresh(TaglibContentProvider.this._curInput);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TagRegistryInstance {
        private final ITagRegistryFactoryInfo _info;
        private final ITagRegistry _registry;
        private final Map<String, Namespace> _namespaces;
        private boolean _isUpToDate;

        public TagRegistryInstance(ITagRegistryFactoryInfo info, ITagRegistry registry) {
            this._info = info;
            this._registry = registry;
            this._namespaces = new ConcurrentHashMap<String, Namespace>();
        }

        public ITagRegistryFactoryInfo getInfo() {
            return this._info;
        }

        public ITagRegistry getRegistry() {
            return this._registry;
        }

        public Map<String, Namespace> getNamespaces() {
            return this._namespaces;
        }

        public synchronized boolean isUpToDate() {
            return this._isUpToDate;
        }

        public synchronized void setUpToDate(boolean isUpToDate) {
            this._isUpToDate = isUpToDate;
        }
    }

    public static class TreePlaceholder {
        private final String _text;
        private final Image _image;

        TreePlaceholder(String text, Image image) {
            this._text = text;
            this._image = image;
        }

        public String getText() {
            return this._text;
        }

        public Image getImage() {
            return this._image;
        }
    }

    private class UpdateNamespacesListJob
    extends Job {
        private final long _timestamp;
        private final IProject _project;
        private final TagRegistryInstance _registry;

        public UpdateNamespacesListJob(IProject project, long timestamp, TagRegistryInstance registry) {
            super("Updating available namespaces for project " + project.getName());
            this._project = project;
            this._timestamp = timestamp;
            this._registry = registry;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!this._project.isAccessible() || this._registry.isUpToDate()) {
                return new Status(8, "org.eclipse.jst.jsf.ui", "");
            }
            Collection libs = this._registry.getRegistry().getAllTagLibraries();
            this._registry.getNamespaces().clear();
            for (Namespace ns : libs) {
                if (ns.getNSUri() == null) continue;
                this._registry.getNamespaces().put(ns.getNSUri(), ns);
            }
            this._registry.setUpToDate(true);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (UpdateNamespacesListJob.this._timestamp == TaglibContentProvider.this._changeStamp.get()) {
                        TaglibContentProvider.this.viewerRefresh(TaglibContentProvider.this._curInput);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }
}

