/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.web.IWebResource;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebAppDeploymentDescriptor;
import org.eclipse.jst.javaee.web.WebAppVersionType;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.JEE5ModelProvider;

public class Web25ModelProvider
extends JEE5ModelProvider {
    private static final String WAR25_CONTENT_TYPE = "org.eclipse.jst.jee.ee5webDD";

    public Web25ModelProvider(IProject proj) {
        this.proj = proj;
        this.setDefaultResourcePath((IPath)new Path("WEB-INF/web.xml"));
    }

    public Object getModelObject(IPath modelPath) {
        IWebResource webRes = (IWebResource)this.getModelResource(modelPath);
        if (webRes != null && webRes.getRootObject() != null) {
            return webRes.getWebApp();
        }
        return null;
    }

    protected String getContentTypeDescriber() {
        return WAR25_CONTENT_TYPE;
    }

    public void populateRoot(XMLResourceImpl res, String name) {
        WebAppDeploymentDescriptor dd = WebFactory.eINSTANCE.createWebAppDeploymentDescriptor();
        dd.getXMLNSPrefixMap().put("", "http://java.sun.com/xml/ns/javaee");
        dd.getXMLNSPrefixMap().put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        WebApp war = WebFactory.eINSTANCE.createWebApp();
        DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
        dn.setValue(name);
        war.getDisplayNames().add(dn);
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.proj);
        if (version != null && version.equals("2.5")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd");
            war.setVersion(WebAppVersionType._25_LITERAL);
        } else if (version != null && version.equals("3.0")) {
            dd.getXSISchemaLocation().put("http://java.sun.com/xml/ns/javaee", "http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd");
            war.setVersion(WebAppVersionType._30_LITERAL);
        } else if (version != null && version.equals("3.1")) {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd");
            war.setVersion(WebAppVersionType._31);
        } else {
            dd.getXMLNSPrefixMap().put("", "http://xmlns.jcp.org/xml/ns/javaee");
            dd.getXSISchemaLocation().put("http://xmlns.jcp.org/xml/ns/javaee", "http://xmlns.jcp.org/xml/ns/javaee/web-app_4_0.xsd");
            war.setVersion(WebAppVersionType._40);
        }
        dd.setWebApp(war);
        res.getContents().add((Object)((EObject)dd));
    }
}

