/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm.debug;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.internal.storage.file.FileReftableStack;
import org.eclipse.jgit.internal.storage.io.BlockSource;
import org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.SymbolicRef;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.util.RefList;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Command
class BenchmarkReftable
extends TextBuiltin {
    @Option(name="--tries")
    private int tries = 10;
    @Option(name="--test")
    private Test test = Test.SCAN;
    @Option(name="--ref")
    private String ref;
    @Option(name="--object-id")
    private String objectId;
    @Argument(index=0)
    private String lsRemotePath;
    @Argument(index=1)
    private String reftablePath;

    BenchmarkReftable() {
    }

    @Override
    protected void run() throws Exception {
        switch (this.test) {
            case SCAN: {
                this.scan();
                break;
            }
            case SEEK_COLD: {
                this.seekCold(this.ref);
                break;
            }
            case SEEK_HOT: {
                this.seekHot(this.ref);
                break;
            }
            case BY_ID_COLD: {
                this.byIdCold(ObjectId.fromString((String)this.objectId));
                break;
            }
            case BY_ID_HOT: {
                this.byIdHot(ObjectId.fromString((String)this.objectId));
                break;
            }
            case WRITE_STACK: {
                this.writeStack();
            }
        }
    }

    private void printf(String fmt, Object ... args) throws IOException {
        this.errw.println(String.format(fmt, args));
    }

    private void writeStack() throws Exception {
        File dir = new File(this.reftablePath);
        File stackFile = new File(String.valueOf(this.reftablePath) + ".stack");
        dir.mkdirs();
        long start = System.currentTimeMillis();
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileReftableStack stack = new FileReftableStack(stackFile, dir, null, () -> new Config());){
            List refs = this.readLsRemote().asList();
            for (Ref r : refs) {
                long j = stack.getMergedReftable().maxUpdateIndex() + 1L;
                if (stack.addReftable(w -> w.setMaxUpdateIndex(j).setMinUpdateIndex(j).begin().writeRef(r))) continue;
                throw new IOException("should succeed");
            }
            long dt = System.currentTimeMillis() - start;
            this.printf("%12s %10d ms  avg %6d us/write", "reftable", dt, dt * 1000L / (long)refs.size());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void scan() throws Exception {
        long start = System.currentTimeMillis();
        int i = 0;
        while (true) {
            if (i >= this.tries) break;
            this.readLsRemote();
            ++i;
        }
        long tot = System.currentTimeMillis() - start;
        this.printf("%12s %10d ms  %6d ms/run", "packed-refs", tot, tot / (long)this.tries);
        start = System.currentTimeMillis();
        i = 0;
        while (true) {
            block30: {
                if (i >= this.tries) {
                    tot = System.currentTimeMillis() - start;
                    this.printf("%12s %10d ms  %6d ms/run", "reftable", tot, tot / (long)this.tries);
                    return;
                }
                Throwable throwable = null;
                Object var7_6 = null;
                try {
                    FileInputStream in = new FileInputStream(this.reftablePath);
                    try {
                        block29: {
                            BlockSource src = BlockSource.from((FileInputStream)in);
                            try {
                                try (ReftableReader reader = new ReftableReader(src);){
                                    Throwable throwable2 = null;
                                    Object var12_15 = null;
                                    try (RefCursor rc = reader.allRefs();){
                                        while (rc.next()) {
                                            rc.getRef();
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                        throw throwable2;
                                    }
                                }
                                if (src == null) break block29;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (src == null) throw throwable;
                                src.close();
                                throw throwable;
                            }
                            src.close();
                        }
                        if (in == null) break block30;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            ++i;
        }
    }

    private RefList<Ref> readLsRemote() throws IOException, FileNotFoundException {
        RefList.Builder list = new RefList.Builder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.lsRemotePath), StandardCharsets.UTF_8));){
            String line;
            Object last = null;
            while ((line = br.readLine()) != null) {
                ObjectId id = ObjectId.fromString((String)line.substring(0, 40));
                String name = line.substring(41, line.length());
                if (last != null && name.endsWith("^{}")) {
                    last = new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, last.getName(), last.getObjectId(), id);
                    list.set(list.size() - 1, (Ref)last);
                    continue;
                }
                last = name.equals("HEAD") ? new SymbolicRef(name, (Ref)new ObjectIdRef.Unpeeled(Ref.Storage.NEW, "refs/heads/master", null)) : new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, name, id);
                list.add((Ref)last);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        list.sort();
        return list.toRefList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void seekCold(String refName) throws Exception {
        int lsTries = Math.min(this.tries, 64);
        long start = System.nanoTime();
        int i = 0;
        while (true) {
            if (i >= lsTries) break;
            this.readLsRemote().get(refName);
            ++i;
        }
        long tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries);
        start = System.nanoTime();
        i = 0;
        while (true) {
            block30: {
                if (i >= this.tries) {
                    tot = System.nanoTime() - start;
                    this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries);
                    return;
                }
                Throwable throwable = null;
                Object var9_8 = null;
                try {
                    FileInputStream in = new FileInputStream(this.reftablePath);
                    try {
                        block29: {
                            BlockSource src = BlockSource.from((FileInputStream)in);
                            try {
                                try (ReftableReader reader = new ReftableReader(src);){
                                    Throwable throwable2 = null;
                                    Object var14_17 = null;
                                    try (RefCursor rc = reader.seekRef(refName);){
                                        while (rc.next()) {
                                            rc.getRef();
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                        throw throwable2;
                                    }
                                }
                                if (src == null) break block29;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (src == null) throw throwable;
                                src.close();
                                throw throwable;
                            }
                            src.close();
                        }
                        if (in == null) break block30;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void seekHot(String refName) throws Exception {
        lsTries = Math.min(this.tries, 64);
        start = System.nanoTime();
        lsRemote = this.readLsRemote();
        i = 0;
        while (i < lsTries) {
            lsRemote.get(refName);
            ++i;
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", new Object[]{"packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries});
        start = System.nanoTime();
        var8_6 = null;
        var9_9 = null;
        try {
            in = new FileInputStream(this.reftablePath);
            try {
                src = BlockSource.from((FileInputStream)in);
                try {
                    reader = new ReftableReader(src);
                    try {
                        i = 0;
                        while (i < this.tries) {
                            var14_17 = null;
                            var15_19 = null;
                            try {
                                rc = reader.seekRef(refName);
                                try {
                                    while (rc.next()) {
                                        rc.getRef();
                                    }
                                }
                                finally {
                                    if (rc != null) {
                                        rc.close();
                                    }
                                }
                            }
                            catch (Throwable var15_20) {
                                if (var14_17 == null) {
                                    var14_17 = var15_20;
                                } else if (var14_17 != var15_20) {
                                    var14_17.addSuppressed(var15_20);
                                }
                                throw var14_17;
                            }
                            ++i;
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    ** if (src == null) goto lbl-1000
                }
                catch (Throwable var9_10) {
                    if (var8_6 == null) {
                        var8_6 = var9_10;
                    } else if (var8_6 != var9_10) {
                        var8_6.addSuppressed(var9_10);
                    }
                    if (src != null) {
                        src.close();
                    }
                    throw var8_6;
                }
lbl-1000:
                // 1 sources

                {
                    src.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var9_11) {
                if (var8_6 == null) {
                    var8_6 = var9_11;
                } else if (var8_6 != var9_11) {
                    var8_6.addSuppressed(var9_11);
                }
                if (in != null) {
                    in.close();
                }
                throw var8_6;
            }
lbl-1000:
            // 1 sources

            {
                in.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var9_12) {
            if (var8_6 == null) {
                var8_6 = var9_12;
            } else if (var8_6 != var9_12) {
                var8_6.addSuppressed(var9_12);
            }
            throw var8_6;
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", new Object[]{"reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void byIdCold(ObjectId id) throws Exception {
        Iterator iterator;
        int lsTries = Math.min(this.tries, 64);
        long start = System.nanoTime();
        int i = 0;
        block14: while (true) {
            if (i >= lsTries) break;
            iterator = this.readLsRemote().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    ++i;
                    continue block14;
                }
                Ref r = (Ref)iterator.next();
                if (!id.equals((AnyObjectId)r.getObjectId())) continue;
            }
            break;
        }
        long tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries);
        start = System.nanoTime();
        i = 0;
        while (true) {
            block32: {
                if (i >= this.tries) {
                    tot = System.nanoTime() - start;
                    this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", "reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries);
                    return;
                }
                Throwable throwable = null;
                iterator = null;
                try {
                    FileInputStream in = new FileInputStream(this.reftablePath);
                    try {
                        block31: {
                            BlockSource src = BlockSource.from((FileInputStream)in);
                            try {
                                try (ReftableReader reader = new ReftableReader(src);){
                                    Throwable throwable2 = null;
                                    Object var14_17 = null;
                                    try (RefCursor rc = reader.byObjectId((AnyObjectId)id);){
                                        while (rc.next()) {
                                            rc.getRef();
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                            throw throwable2;
                                        }
                                        if (throwable2 == throwable3) throw throwable2;
                                        throwable2.addSuppressed(throwable3);
                                        throw throwable2;
                                    }
                                }
                                if (src == null) break block31;
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                if (src == null) throw throwable;
                                src.close();
                                throw throwable;
                            }
                            src.close();
                        }
                        if (in == null) break block32;
                    }
                    catch (Throwable throwable5) {
                        if (throwable == null) {
                            throwable = throwable5;
                        } else if (throwable != throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        if (in == null) throw throwable;
                        in.close();
                        throw throwable;
                    }
                    in.close();
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                        throw throwable;
                    }
                    if (throwable == throwable6) throw throwable;
                    throwable.addSuppressed(throwable6);
                    throw throwable;
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void byIdHot(ObjectId id) throws Exception {
        lsTries = Math.min(this.tries, 64);
        start = System.nanoTime();
        lsRemote = this.readLsRemote();
        i = 0;
        while (i < lsTries) {
            for (Ref r : lsRemote) {
                if (!id.equals((AnyObjectId)r.getObjectId())) continue;
            }
            ++i;
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", new Object[]{"packed-refs", tot / 1000L, (double)tot / (double)lsTries / 1000.0, lsTries});
        start = System.nanoTime();
        var8_6 = null;
        var9_8 = null;
        try {
            in = new FileInputStream(this.reftablePath);
            try {
                src = BlockSource.from((FileInputStream)in);
                try {
                    reader = new ReftableReader(src);
                    try {
                        i = 0;
                        while (i < this.tries) {
                            var14_17 = null;
                            var15_19 = null;
                            try {
                                rc = reader.byObjectId((AnyObjectId)id);
                                try {
                                    while (rc.next()) {
                                        rc.getRef();
                                    }
                                }
                                finally {
                                    if (rc != null) {
                                        rc.close();
                                    }
                                }
                            }
                            catch (Throwable var15_20) {
                                if (var14_17 == null) {
                                    var14_17 = var15_20;
                                } else if (var14_17 != var15_20) {
                                    var14_17.addSuppressed(var15_20);
                                }
                                throw var14_17;
                            }
                            ++i;
                        }
                    }
                    finally {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    ** if (src == null) goto lbl-1000
                }
                catch (Throwable var9_9) {
                    if (var8_6 == null) {
                        var8_6 = var9_9;
                    } else if (var8_6 != var9_9) {
                        var8_6.addSuppressed(var9_9);
                    }
                    if (src != null) {
                        src.close();
                    }
                    throw var8_6;
                }
lbl-1000:
                // 1 sources

                {
                    src.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var9_10) {
                if (var8_6 == null) {
                    var8_6 = var9_10;
                } else if (var8_6 != var9_10) {
                    var8_6.addSuppressed(var9_10);
                }
                if (in != null) {
                    in.close();
                }
                throw var8_6;
            }
lbl-1000:
            // 1 sources

            {
                in.close();
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (Throwable var9_11) {
            if (var8_6 == null) {
                var8_6 = var9_11;
            } else if (var8_6 != var9_11) {
                var8_6.addSuppressed(var9_11);
            }
            throw var8_6;
        }
        tot = System.nanoTime() - start;
        this.printf("%12s %10d usec  %9.1f usec/run  %5d runs", new Object[]{"reftable", tot / 1000L, (double)tot / (double)this.tries / 1000.0, this.tries});
    }

    static enum Test {
        SCAN,
        SEEK_COLD,
        SEEK_HOT,
        BY_ID_COLD,
        BY_ID_HOT,
        WRITE_STACK;

    }
}

