/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.clipboard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ReflectionUtil;
import org.eclipse.graphiti.ui.internal.util.clipboard.UriTransfer;
import org.eclipse.graphiti.ui.internal.util.clipboard.UriTransferData;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public final class ModelClipboard {
    private static final String EMPTY_TOSTRING_PLACEHOLDER = "<empty>";
    private static final EObject[] NO_E_OBJECTS = new EObject[0];
    private static final ModelClipboard INSTANCE = new ModelClipboard();

    private ModelClipboard() {
    }

    public static ModelClipboard getDefault() {
        return INSTANCE;
    }

    public synchronized void setContent(EObject[] objects) throws IllegalStateException {
        if (objects == null) {
            throw new IllegalArgumentException("EObject[] objects must not be null");
        }
        if (objects.length == 0) {
            return;
        }
        if (this.canUseNative()) {
            this.setNativeContentObjects(Arrays.asList(objects));
        }
    }

    public synchronized EObject[] getContentAsEObjects(ResourceSet resourceSet) throws IllegalStateException {
        if (resourceSet == null) {
            throw new IllegalArgumentException("ResourceSet resourceSet must not be null");
        }
        List<Object> eObjectList = this.canUseNative() ? this.getLocalSelectionContent() : Collections.emptyList();
        if (eObjectList.isEmpty()) {
            return NO_E_OBJECTS;
        }
        return eObjectList.toArray(new EObject[eObjectList.size()]);
    }

    private List<EObject> getLocalSelectionContent() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        try {
            ISelection contents = (ISelection)cb.getContents((Transfer)LocalSelectionTransfer.getTransfer());
            if (contents instanceof IStructuredSelection && !contents.isEmpty()) {
                List localList;
                List list = ((IStructuredSelection)contents).toList();
                for (Object o : list) {
                    if (o instanceof EObject) continue;
                    List<EObject> list2 = Collections.emptyList();
                    return list2;
                }
                List list3 = localList = list;
                return list3;
            }
            List<EObject> list = Collections.emptyList();
            return list;
        }
        finally {
            cb.dispose();
        }
    }

    public boolean isCompositionAllowed(EObject parent, EObject[] objects) {
        EObject[] eObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            EObject object = eObjectArray[n2];
            List<EReference> assocs = ModelClipboard.findUsableTargetAssociations(parent, object);
            if (assocs.size() > 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Collection<EObject> duplicateAndPaste(Object target, TransactionalEditingDomain transactionalEditingDomain) throws IllegalStateException {
        EObject[] srcObjects;
        TransactionalEditingDomain parentEditingDomain;
        if (transactionalEditingDomain == null) {
            throw new IllegalStateException("TransactionalEditingDomain targetConnection should not be null");
        }
        EObject parent = GraphitiUiInternal.getEmfService().getEObject(target);
        if (parent != null && (parentEditingDomain = TransactionUtil.getEditingDomain((EObject)parent)) != null && !transactionalEditingDomain.equals(parentEditingDomain)) {
            throw new IllegalStateException("Ambiguous TransactionalEditingDomains: transactionalEditingDomain: " + transactionalEditingDomain + " <-> TransactionalEditingDomain of target object: " + parentEditingDomain + ". Not clear which one to use for copy.");
        }
        try {
            srcObjects = this.getContentAsEObjects(transactionalEditingDomain.getResourceSet());
            if (srcObjects.length == 0) {
                return null;
            }
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (Exception e) {
            T.racer().error(e.getMessage(), e);
            return null;
        }
        CommandStack commandStack = transactionalEditingDomain.getCommandStack();
        Collection[] copyResults = new Collection[1];
        try {
            EObject[] srcObjectsFinal = srcObjects;
            CopyCommand command = new CopyCommand(transactionalEditingDomain, parent, srcObjectsFinal, copyResults);
            commandStack.execute((Command)command);
            return copyResults[0];
        }
        catch (OperationCanceledException e) {
            this.rollback(transactionalEditingDomain);
            return null;
        }
        catch (Exception e) {
            T.racer().error(e.getMessage(), e);
            this.rollback(transactionalEditingDomain);
            return null;
        }
    }

    private Collection<EObject> deepCopy(final EObject[] srcObjects) {
        if (srcObjects == null) {
            throw new IllegalArgumentException("EObject[] srcObjects must not be null");
        }
        if (srcObjects.length == 0) {
            throw new IllegalArgumentException("EObject[] srcObjects.length must not be 0");
        }
        final Collection[] result = new Collection[1];
        if (ModelClipboard.canUseUI()) {
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
                    result[0] = copier.copyAll(Arrays.asList(srcObjects));
                    copier.copyReferences();
                }
            });
            return result[0];
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        result[0] = copier.copyAll(Arrays.asList(srcObjects));
        copier.copyReferences();
        return result[0];
    }

    private void addToCompositeParent(EObject parent, EObject[] objects, EReference association) {
        if (parent == null) {
            throw new IllegalStateException("Parent must not be null");
        }
        EObject[] eObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                EReference assoc;
                EObject object;
                block9: {
                    object = eObjectArray[n2];
                    EObject objectParent = object.eContainer();
                    if (objectParent == null) break block9;
                    if (T.racer().debug()) {
                        String msg = "Ignoring " + ModelClipboard.toObjectString(object) + " for parent assignment. Already assigned to " + ModelClipboard.toObjectString(objectParent);
                        T.racer().debug(msg);
                    }
                    break block10;
                }
                List<EReference> assocs = ModelClipboard.findUsableTargetAssociations(parent, object);
                switch (assocs.size()) {
                    case 0: {
                        String msg = "No composite associations found for " + ModelClipboard.toObjectString(parent.eClass()) + " -> " + ModelClipboard.toObjectString(object.eClass());
                        T.racer().debug(msg);
                        break block10;
                    }
                    case 1: {
                        assoc = assocs.get(0);
                        break;
                    }
                    default: {
                        if (association != null) {
                            if (!assocs.contains(association)) {
                                throw new IllegalStateException("Given association " + association.getName() + " not valid among " + ModelClipboard.toAssociationNames(assocs));
                            }
                            assoc = association;
                            break;
                        }
                        throw new IllegalStateException("Multiple associations available " + ModelClipboard.toAssociationNames(assocs));
                    }
                }
                ModelClipboard.compose(parent, object, assoc);
            }
            ++n2;
        }
    }

    private static List<String> toAssociationNames(List<EReference> assocs) {
        ArrayList<String> names = new ArrayList<String>(assocs.size());
        for (EReference assoc : assocs) {
            names.add(assoc.getName());
        }
        return names;
    }

    private static String toObjectString(Object o) {
        if (o instanceof Collection) {
            return ModelClipboard.toObjectsString((Collection)o);
        }
        return ModelClipboard.toObjectsString(Collections.singleton(o));
    }

    private static String toObjectsString(Collection<?> objects) {
        StringBuilder b = new StringBuilder();
        for (Object o : objects) {
            if (o instanceof EObject) {
                EObject object = (EObject)o;
                String name = GraphitiUiInternal.getEmfService().getObjectName(object);
                String type = object.eClass().getName();
                b.append(type).append(" '").append(name).append("'");
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    private static void compose(EObject parent, EObject child, EReference assoc) {
        Object o = parent.eGet((EStructuralFeature)assoc, true);
        if (o instanceof List) {
            List list = (List)o;
            list.add(child);
        } else {
            parent.eSet((EStructuralFeature)assoc, (Object)child);
        }
    }

    private Map<EObject, EObject> getTargetRootElements(Collection<EObject> result, EObject[] srcElements) {
        LinkedHashMap<EObject, EObject> elements = new LinkedHashMap<EObject, EObject>(srcElements.length);
        EObject[] resultArray = new EObject[result.size()];
        resultArray = result.toArray(resultArray);
        int i = 0;
        while (i < srcElements.length) {
            elements.put(resultArray[i], srcElements[i]);
            ++i;
        }
        return elements;
    }

    static List<EReference> findUsableTargetAssociations(EObject parent, EObject child) {
        ArrayList<EReference> compositeAssociations = new ArrayList<EReference>();
        Collection<EReference> contents = ModelClipboard.getContainmentReferences(parent.eClass());
        for (EReference reference : contents) {
            EClassifier referenceType = reference.getEType();
            if (!referenceType.isInstance((Object)child)) continue;
            Object value = parent.eGet((EStructuralFeature)reference);
            if (reference.getUpperBound() == 1 && value != null) continue;
            compositeAssociations.add(reference);
        }
        return compositeAssociations;
    }

    private static Collection<EReference> getContainmentReferences(EClass eclass) {
        ArrayList<EReference> assocs = new ArrayList<EReference>();
        EList contents = eclass.eContents();
        for (EObject object : contents) {
            EReference reference;
            if (!(object instanceof EReference) || !(reference = (EReference)object).isContainment()) continue;
            assocs.add(reference);
        }
        EList superTypes = eclass.getESuperTypes();
        Iterator iterator = superTypes.iterator();
        while (iterator.hasNext()) {
            assocs.addAll(ModelClipboard.getContainmentReferences((EClass)iterator.next()));
        }
        return assocs;
    }

    private void rollback(final TransactionalEditingDomain targetTED) {
        try {
            targetTED.runExclusive(new Runnable(){

                @Override
                public void run() {
                    EList resources = targetTED.getResourceSet().getResources();
                    for (Resource resource : resources) {
                        resource.unload();
                        resource.setModified(false);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized List<String> getContentAsStringList() {
        List<String> strings = Collections.emptyList();
        if (this.canUseNative()) {
            strings = ModelClipboard.getNativeContent();
        }
        return strings;
    }

    private void setNativeContentObjects(List<EObject> objects) {
        Map<Transfer, Object> nativeFormat = this.toTransferObjects(objects);
        int size = nativeFormat.size();
        if (size > 0) {
            Object[] data = nativeFormat.values().toArray(new Object[size]);
            Transfer[] dataTypes = nativeFormat.keySet().toArray(new Transfer[size]);
            Clipboard cb = new Clipboard(Display.getCurrent());
            try {
                cb.setContents(data, dataTypes);
            }
            finally {
                cb.dispose();
            }
        }
    }

    private synchronized Map<Transfer, Object> toTransferObjects(List<EObject> objects) {
        Map<Transfer, Object> empty = Collections.emptyMap();
        int size = objects.size();
        if (size == 0) {
            return empty;
        }
        ArrayList<String> uriStrings = new ArrayList<String>(size);
        ArrayList<IFile> files = new ArrayList<IFile>(size);
        ArrayList<String> filePaths = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            EObject o = objects.get(i);
            uriStrings.add(EcoreUtil.getURI((EObject)o).toString());
            IFile file = null;
            file = this.isSoleContent(o) ? GraphitiUiInternal.getEmfService().getFile(o) : (IFile)Platform.getAdapterManager().getAdapter((Object)o, IFile.class);
            if (file != null && file.exists() && !files.contains(file)) {
                files.add(file);
                filePaths.add(file.getLocation().toOSString());
            }
            ++i;
        }
        HashMap<Transfer, Object> result = new HashMap<Transfer, Object>(7);
        UriTransferData data = new UriTransferData(uriStrings);
        StructuredSelection localSelection = new StructuredSelection(objects);
        LocalSelectionTransfer.getTransfer().setSelection((ISelection)localSelection);
        result.put((Transfer)LocalSelectionTransfer.getTransfer(), new Object());
        result.put((Transfer)UriTransfer.getInstance(), data);
        if (!filePaths.isEmpty()) {
            result.put((Transfer)FileTransfer.getInstance(), filePaths.toArray(new String[filePaths.size()]));
            try {
                Transfer resourceTransfer = ReflectionUtil.getResourceTransfer();
                if (resourceTransfer != null) {
                    result.put(resourceTransfer, files.toArray(new IResource[files.size()]));
                }
            }
            catch (Exception e) {
                T.racer().debug(e.getMessage());
            }
        }
        result.put((Transfer)TextTransfer.getInstance(), this.toExtendedString(objects));
        return result;
    }

    private boolean isSoleContent(EObject o) {
        Resource res = o.eResource();
        return res != null && res.getContents().size() == 1;
    }

    private static List<String> getNativeContent() {
        Clipboard cb = new Clipboard(Display.getCurrent());
        try {
            UriTransferData contents = (UriTransferData)cb.getContents((Transfer)UriTransfer.getInstance());
            if (contents != null) {
                List<String> list = contents.getUriStrings();
                return list;
            }
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            cb.dispose();
        }
    }

    private String toExtendedString(List<EObject> objects) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < objects.size()) {
            EObject o = objects.get(i);
            GraphitiUiInternal.getEmfService().toString(o, result);
            if (i < objects.size() - 1) {
                result.append(UriTransferData.LINE_SEP);
            }
            ++i;
        }
        return result.toString();
    }

    public String toString() {
        if (this.getContentAsStringList().size() <= 0) {
            return EMPTY_TOSTRING_PLACEHOLDER;
        }
        List<String> content = this.getContentAsStringList();
        String[] strings = content.toArray(new String[content.size()]);
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < strings.length) {
            String s = strings[i];
            b.append(s);
            if (i < strings.length - 1) {
                b.append(UriTransferData.LINE_SEP);
            }
            ++i;
        }
        return b.toString();
    }

    private synchronized boolean canUseNative() {
        boolean result = ModelClipboard.canUseUI();
        if (!result) {
            throw new IllegalStateException("ModelClipboard must be called from UI thread.");
        }
        return result;
    }

    private static boolean canUseUI() {
        return Display.getCurrent() != null;
    }

    private final class CopyCommand
    extends RecordingCommand {
        private final EObject parent;
        private final EObject[] srcObjectsFinal;
        private final Collection<EObject>[] copyResults;

        private CopyCommand(TransactionalEditingDomain domain, EObject parent, EObject[] srcObjectsFinal, Collection<EObject>[] copyResults) {
            super(domain);
            this.parent = parent;
            this.srcObjectsFinal = srcObjectsFinal;
            this.copyResults = copyResults;
        }

        public String getLabel() {
            return Messages.ModelClipBoardPasteAction_0_xfld;
        }

        protected void doExecute() {
            Collection copyResult = ModelClipboard.this.deepCopy(this.srcObjectsFinal);
            Map targetRootElements = ModelClipboard.this.getTargetRootElements(copyResult, this.srcObjectsFinal);
            Set targetElements = targetRootElements.keySet();
            EObject[] elements = targetElements.toArray(new EObject[targetElements.size()]);
            if (this.parent != null) {
                ModelClipboard.this.addToCompositeParent(this.parent, elements, null);
            }
            this.copyResults[0] = copyResult;
        }
    }
}

